/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum IpVersion {
    Unknown(0, "unknown"),
    Ipv4(1, "ipv4"),
    Ipv6(2, "ipv6");

    private static final Map<Integer, IpVersion> VALUE_MAP;
    private final String name;
    private final int value;

    private IpVersion(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static IpVersion forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, IpVersion> b = ImmutableMap.builder();
        for (IpVersion enumItem : IpVersion.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

