/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;

public class Ipv6AddressNoZone
extends Ipv6Address
implements Serializable {
    private static final long serialVersionUID = -8132834319977195251L;
    private static final Pattern[] patterns;
    public static final List<String> PATTERN_CONSTANTS;

    @ConstructorProperties(value={"value"})
    public Ipv6AddressNoZone(String _value) {
        super(_value);
        Objects.requireNonNull(_value, "Supplied value may not be null");
        for (Pattern p : patterns) {
            Preconditions.checkArgument(p.matcher(_value).matches(), "Supplied value \"%s\" does not match required pattern \"%s\"", (Object)_value, (Object)p);
        }
    }

    public Ipv6AddressNoZone(Ipv6AddressNoZone source) {
        super(source);
    }

    public Ipv6AddressNoZone(Ipv6Address source) {
        super(source);
    }

    public static Ipv6AddressNoZone getDefaultInstance(String defaultValue) {
        return new Ipv6AddressNoZone(defaultValue);
    }

    static {
        PATTERN_CONSTANTS = ImmutableList.of("^(?:[0-9a-fA-F:\\.]*)$");
        Pattern[] a = new Pattern[PATTERN_CONSTANTS.size()];
        int i = 0;
        for (String regEx : PATTERN_CONSTANTS) {
            a[i++] = Pattern.compile(regEx);
        }
        patterns = a;
    }
}

