/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.ModuleType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.Module;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.ModuleKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.Configuration;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.config.rev130405.modules.module.State;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ModuleBuilder
implements Builder<Module> {
    private Configuration _configuration;
    private ModuleKey _key;
    private String _name;
    private State _state;
    private Class<? extends ModuleType> _type;
    Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = Collections.emptyMap();

    public ModuleBuilder() {
    }

    public ModuleBuilder(Module base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new ModuleKey(base.getName(), base.getType());
            this._name = base.getName();
            this._type = base.getType();
        } else {
            this._key = base.getKey();
            this._name = this._key.getName();
            this._type = this._key.getType();
        }
        this._configuration = base.getConfiguration();
        this._state = base.getState();
        if (base instanceof ModuleImpl) {
            ModuleImpl impl = (ModuleImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    public ModuleKey getKey() {
        return this._key;
    }

    public String getName() {
        return this._name;
    }

    public State getState() {
        return this._state;
    }

    public Class<? extends ModuleType> getType() {
        return this._type;
    }

    public <E extends Augmentation<Module>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ModuleBuilder setConfiguration(Configuration value) {
        this._configuration = value;
        return this;
    }

    public ModuleBuilder setKey(ModuleKey value) {
        this._key = value;
        return this;
    }

    public ModuleBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ModuleBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ModuleBuilder setType(Class<? extends ModuleType> value) {
        this._type = value;
        return this;
    }

    public ModuleBuilder addAugmentation(Class<? extends Augmentation<Module>> augmentationType, Augmentation<Module> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ModuleBuilder removeAugmentation(Class<? extends Augmentation<Module>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Module build() {
        return new ModuleImpl(this);
    }

    private static final class ModuleImpl
    implements Module {
        private final Configuration _configuration;
        private final ModuleKey _key;
        private final String _name;
        private final State _state;
        private final Class<? extends ModuleType> _type;
        private Map<Class<? extends Augmentation<Module>>, Augmentation<Module>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Module> getImplementedInterface() {
            return Module.class;
        }

        private ModuleImpl(ModuleBuilder base) {
            if (base.getKey() == null) {
                this._key = new ModuleKey(base.getName(), base.getType());
                this._name = base.getName();
                this._type = base.getType();
            } else {
                this._key = base.getKey();
                this._name = this._key.getName();
                this._type = this._key.getType();
            }
            this._configuration = base.getConfiguration();
            this._state = base.getState();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Module>>, Augmentation<Module>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Module>>, Augmentation<Module>>(base.augmentation);
                }
            }
        }

        @Override
        public Configuration getConfiguration() {
            return this._configuration;
        }

        @Override
        public ModuleKey getKey() {
            return this._key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Class<? extends ModuleType> getType() {
            return this._type;
        }

        @Override
        public <E extends Augmentation<Module>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._configuration);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._state);
            result = 31 * result + Objects.hashCode(this._type);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Module.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Module other = (Module)obj;
            if (!Objects.equals(this._configuration, other.getConfiguration())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._state, other.getState())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ModuleImpl otherImpl = (ModuleImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Module>>, Augmentation<Module>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Module [";
            StringBuilder builder = new StringBuilder(name);
            if (this._configuration != null) {
                builder.append("_configuration=");
                builder.append(this._configuration);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._name != null) {
                builder.append("_name=");
                builder.append(this._name);
                builder.append(", ");
            }
            if (this._state != null) {
                builder.append("_state=");
                builder.append(this._state);
                builder.append(", ");
            }
            if (this._type != null) {
                builder.append("_type=");
                builder.append(this._type);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

