/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.lsp.db.version.tlv;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LspDbVersionBuilder
implements Builder<LspDbVersion> {
    private BigInteger _lspDbVersionValue;
    Map<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKLSPDBVERSIONVALUERANGE_RANGES;

    public LspDbVersionBuilder() {
    }

    public LspDbVersionBuilder(LspDbVersion base) {
        AugmentationHolder casted;
        this._lspDbVersionValue = base.getLspDbVersionValue();
        if (base instanceof LspDbVersionImpl) {
            LspDbVersionImpl impl = (LspDbVersionImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public BigInteger getLspDbVersionValue() {
        return this._lspDbVersionValue;
    }

    public <E extends Augmentation<LspDbVersion>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkLspDbVersionValueRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKLSPDBVERSIONVALUERANGE_RANGES) {
            if (!r.contains(value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKLSPDBVERSIONVALUERANGE_RANGES)));
    }

    public LspDbVersionBuilder setLspDbVersionValue(BigInteger value) {
        if (value != null) {
            LspDbVersionBuilder.checkLspDbVersionValueRange(value);
        }
        this._lspDbVersionValue = value;
        return this;
    }

    public LspDbVersionBuilder addAugmentation(Class<? extends Augmentation<LspDbVersion>> augmentationType, Augmentation<LspDbVersion> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LspDbVersionBuilder removeAugmentation(Class<? extends Augmentation<LspDbVersion>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LspDbVersion build() {
        return new LspDbVersionImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed(BigInteger.ZERO, new BigInteger("18446744073709551615"));
        CHECKLSPDBVERSIONVALUERANGE_RANGES = a;
    }

    private static final class LspDbVersionImpl
    implements LspDbVersion {
        private final BigInteger _lspDbVersionValue;
        private Map<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LspDbVersion> getImplementedInterface() {
            return LspDbVersion.class;
        }

        private LspDbVersionImpl(LspDbVersionBuilder base) {
            this._lspDbVersionValue = base.getLspDbVersionValue();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getLspDbVersionValue() {
            return this._lspDbVersionValue;
        }

        @Override
        public <E extends Augmentation<LspDbVersion>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lspDbVersionValue);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LspDbVersion.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LspDbVersion other = (LspDbVersion)obj;
            if (!Objects.equals(this._lspDbVersionValue, other.getLspDbVersionValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LspDbVersionImpl otherImpl = (LspDbVersionImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LspDbVersion>>, Augmentation<LspDbVersion>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "LspDbVersion [";
            StringBuilder builder = new StringBuilder(name);
            if (this._lspDbVersionValue != null) {
                builder.append("_lspDbVersionValue=");
                builder.append(this._lspDbVersionValue);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

