/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125;

import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class IsoSystemIdentifier
implements Serializable {
    private static final long serialVersionUID = 5046538823000041421L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length >= 6 && length <= 6) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid length: %s, expected: [[6..6]].", Arrays.toString(value)));
    }

    @ConstructorProperties(value={"value"})
    public IsoSystemIdentifier(byte[] _value) {
        if (_value != null) {
            IsoSystemIdentifier.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public IsoSystemIdentifier(IsoSystemIdentifier source) {
        this._value = source._value;
    }

    public static IsoSystemIdentifier getDefaultInstance(String defaultValue) {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        return new IsoSystemIdentifier(baseEncoding.decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IsoSystemIdentifier other = (IsoSystemIdentifier)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(IsoSystemIdentifier.class.getSimpleName()).append(" [");
        boolean first = true;
        if (this._value != null) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("_value=");
            builder.append(Arrays.toString(this._value));
        }
        return builder.append(']').toString();
    }
}

