/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastReceivedError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.error.messages.LastSentError;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ErrorMessagesBuilder
implements Builder<ErrorMessages> {
    private LastReceivedError _lastReceivedError;
    private LastSentError _lastSentError;
    private Long _receivedErrorMsgCount;
    private Long _sentErrorMsgCount;
    Map<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>> augmentation = Collections.emptyMap();

    public ErrorMessagesBuilder() {
    }

    public ErrorMessagesBuilder(ErrorMessages base) {
        AugmentationHolder casted;
        this._lastReceivedError = base.getLastReceivedError();
        this._lastSentError = base.getLastSentError();
        this._receivedErrorMsgCount = base.getReceivedErrorMsgCount();
        this._sentErrorMsgCount = base.getSentErrorMsgCount();
        if (base instanceof ErrorMessagesImpl) {
            ErrorMessagesImpl impl = (ErrorMessagesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public LastReceivedError getLastReceivedError() {
        return this._lastReceivedError;
    }

    public LastSentError getLastSentError() {
        return this._lastSentError;
    }

    public Long getReceivedErrorMsgCount() {
        return this._receivedErrorMsgCount;
    }

    public Long getSentErrorMsgCount() {
        return this._sentErrorMsgCount;
    }

    public <E extends Augmentation<ErrorMessages>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public ErrorMessagesBuilder setLastReceivedError(LastReceivedError value) {
        this._lastReceivedError = value;
        return this;
    }

    public ErrorMessagesBuilder setLastSentError(LastSentError value) {
        this._lastSentError = value;
        return this;
    }

    private static void checkReceivedErrorMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ErrorMessagesBuilder setReceivedErrorMsgCount(Long value) {
        if (value != null) {
            ErrorMessagesBuilder.checkReceivedErrorMsgCountRange(value);
        }
        this._receivedErrorMsgCount = value;
        return this;
    }

    private static void checkSentErrorMsgCountRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public ErrorMessagesBuilder setSentErrorMsgCount(Long value) {
        if (value != null) {
            ErrorMessagesBuilder.checkSentErrorMsgCountRange(value);
        }
        this._sentErrorMsgCount = value;
        return this;
    }

    public ErrorMessagesBuilder addAugmentation(Class<? extends Augmentation<ErrorMessages>> augmentationType, Augmentation<ErrorMessages> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ErrorMessagesBuilder removeAugmentation(Class<? extends Augmentation<ErrorMessages>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ErrorMessages build() {
        return new ErrorMessagesImpl(this);
    }

    private static final class ErrorMessagesImpl
    implements ErrorMessages {
        private final LastReceivedError _lastReceivedError;
        private final LastSentError _lastSentError;
        private final Long _receivedErrorMsgCount;
        private final Long _sentErrorMsgCount;
        private Map<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<ErrorMessages> getImplementedInterface() {
            return ErrorMessages.class;
        }

        private ErrorMessagesImpl(ErrorMessagesBuilder base) {
            this._lastReceivedError = base.getLastReceivedError();
            this._lastSentError = base.getLastSentError();
            this._receivedErrorMsgCount = base.getReceivedErrorMsgCount();
            this._sentErrorMsgCount = base.getSentErrorMsgCount();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>>(base.augmentation);
                }
            }
        }

        @Override
        public LastReceivedError getLastReceivedError() {
            return this._lastReceivedError;
        }

        @Override
        public LastSentError getLastSentError() {
            return this._lastSentError;
        }

        @Override
        public Long getReceivedErrorMsgCount() {
            return this._receivedErrorMsgCount;
        }

        @Override
        public Long getSentErrorMsgCount() {
            return this._sentErrorMsgCount;
        }

        @Override
        public <E extends Augmentation<ErrorMessages>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lastReceivedError);
            result = 31 * result + Objects.hashCode(this._lastSentError);
            result = 31 * result + Objects.hashCode(this._receivedErrorMsgCount);
            result = 31 * result + Objects.hashCode(this._sentErrorMsgCount);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ErrorMessages.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ErrorMessages other = (ErrorMessages)obj;
            if (!Objects.equals(this._lastReceivedError, other.getLastReceivedError())) {
                return false;
            }
            if (!Objects.equals(this._lastSentError, other.getLastSentError())) {
                return false;
            }
            if (!Objects.equals(this._receivedErrorMsgCount, other.getReceivedErrorMsgCount())) {
                return false;
            }
            if (!Objects.equals(this._sentErrorMsgCount, other.getSentErrorMsgCount())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ErrorMessagesImpl otherImpl = (ErrorMessagesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ErrorMessages>>, Augmentation<ErrorMessages>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "ErrorMessages [";
            StringBuilder builder = new StringBuilder(name);
            if (this._lastReceivedError != null) {
                builder.append("_lastReceivedError=");
                builder.append(this._lastReceivedError);
                builder.append(", ");
            }
            if (this._lastSentError != null) {
                builder.append("_lastSentError=");
                builder.append(this._lastSentError);
                builder.append(", ");
            }
            if (this._receivedErrorMsgCount != null) {
                builder.append("_receivedErrorMsgCount=");
                builder.append(this._receivedErrorMsgCount);
                builder.append(", ");
            }
            if (this._sentErrorMsgCount != null) {
                builder.append("_sentErrorMsgCount=");
                builder.append(this._sentErrorMsgCount);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

