/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Preferences;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LocalPrefBuilder
implements Builder<LocalPref> {
    private Short _deadtimer;
    private String _ipAddress;
    private Short _keepalive;
    private Integer _sessionId;
    Map<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>> augmentation = Collections.emptyMap();

    public LocalPrefBuilder() {
    }

    public LocalPrefBuilder(Preferences arg) {
        this._keepalive = arg.getKeepalive();
        this._deadtimer = arg.getDeadtimer();
        this._ipAddress = arg.getIpAddress();
        this._sessionId = arg.getSessionId();
    }

    public LocalPrefBuilder(LocalPref base) {
        AugmentationHolder casted;
        this._deadtimer = base.getDeadtimer();
        this._ipAddress = base.getIpAddress();
        this._keepalive = base.getKeepalive();
        this._sessionId = base.getSessionId();
        if (base instanceof LocalPrefImpl) {
            LocalPrefImpl impl = (LocalPrefImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Preferences) {
            this._keepalive = ((Preferences)arg).getKeepalive();
            this._deadtimer = ((Preferences)arg).getDeadtimer();
            this._ipAddress = ((Preferences)arg).getIpAddress();
            this._sessionId = ((Preferences)arg).getSessionId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Preferences] \nbut was: " + arg);
        }
    }

    public Short getDeadtimer() {
        return this._deadtimer;
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public Short getKeepalive() {
        return this._keepalive;
    }

    public Integer getSessionId() {
        return this._sessionId;
    }

    public <E extends Augmentation<LocalPref>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkDeadtimerRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public LocalPrefBuilder setDeadtimer(Short value) {
        if (value != null) {
            LocalPrefBuilder.checkDeadtimerRange(value);
        }
        this._deadtimer = value;
        return this;
    }

    public LocalPrefBuilder setIpAddress(String value) {
        this._ipAddress = value;
        return this;
    }

    private static void checkKeepaliveRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public LocalPrefBuilder setKeepalive(Short value) {
        if (value != null) {
            LocalPrefBuilder.checkKeepaliveRange(value);
        }
        this._keepalive = value;
        return this;
    }

    private static void checkSessionIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public LocalPrefBuilder setSessionId(Integer value) {
        if (value != null) {
            LocalPrefBuilder.checkSessionIdRange(value);
        }
        this._sessionId = value;
        return this;
    }

    public LocalPrefBuilder addAugmentation(Class<? extends Augmentation<LocalPref>> augmentationType, Augmentation<LocalPref> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LocalPrefBuilder removeAugmentation(Class<? extends Augmentation<LocalPref>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public LocalPref build() {
        return new LocalPrefImpl(this);
    }

    private static final class LocalPrefImpl
    implements LocalPref {
        private final Short _deadtimer;
        private final String _ipAddress;
        private final Short _keepalive;
        private final Integer _sessionId;
        private Map<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<LocalPref> getImplementedInterface() {
            return LocalPref.class;
        }

        private LocalPrefImpl(LocalPrefBuilder base) {
            this._deadtimer = base.getDeadtimer();
            this._ipAddress = base.getIpAddress();
            this._keepalive = base.getKeepalive();
            this._sessionId = base.getSessionId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getDeadtimer() {
            return this._deadtimer;
        }

        @Override
        public String getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public Short getKeepalive() {
            return this._keepalive;
        }

        @Override
        public Integer getSessionId() {
            return this._sessionId;
        }

        @Override
        public <E extends Augmentation<LocalPref>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadtimer);
            result = 31 * result + Objects.hashCode(this._ipAddress);
            result = 31 * result + Objects.hashCode(this._keepalive);
            result = 31 * result + Objects.hashCode(this._sessionId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!LocalPref.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            LocalPref other = (LocalPref)obj;
            if (!Objects.equals(this._deadtimer, other.getDeadtimer())) {
                return false;
            }
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (!Objects.equals(this._keepalive, other.getKeepalive())) {
                return false;
            }
            if (!Objects.equals(this._sessionId, other.getSessionId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LocalPrefImpl otherImpl = (LocalPrefImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<LocalPref>>, Augmentation<LocalPref>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "LocalPref [";
            StringBuilder builder = new StringBuilder(name);
            if (this._deadtimer != null) {
                builder.append("_deadtimer=");
                builder.append(this._deadtimer);
                builder.append(", ");
            }
            if (this._ipAddress != null) {
                builder.append("_ipAddress=");
                builder.append(this._ipAddress);
                builder.append(", ");
            }
            if (this._keepalive != null) {
                builder.append("_keepalive=");
                builder.append(this._keepalive);
                builder.append(", ");
            }
            if (this._sessionId != null) {
                builder.append("_sessionId=");
                builder.append(this._sessionId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

