/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.svec.object.Svec;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SvecBuilder
implements Builder<Svec> {
    private List<RequestId> _requestsIds;
    private Boolean _ignore;
    private Boolean _linkDiverse;
    private Boolean _nodeDiverse;
    private Boolean _processingRule;
    private Boolean _srlgDiverse;
    Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> augmentation = Collections.emptyMap();

    public SvecBuilder() {
    }

    public SvecBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public SvecBuilder(Svec base) {
        AugmentationHolder casted;
        this._requestsIds = base.getRequestsIds();
        this._ignore = base.isIgnore();
        this._linkDiverse = base.isLinkDiverse();
        this._nodeDiverse = base.isNodeDiverse();
        this._processingRule = base.isProcessingRule();
        this._srlgDiverse = base.isSrlgDiverse();
        if (base instanceof SvecImpl) {
            SvecImpl impl = (SvecImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader] \nbut was: " + arg);
        }
    }

    public List<RequestId> getRequestsIds() {
        return this._requestsIds;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isLinkDiverse() {
        return this._linkDiverse;
    }

    public Boolean isNodeDiverse() {
        return this._nodeDiverse;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isSrlgDiverse() {
        return this._srlgDiverse;
    }

    public <E extends Augmentation<Svec>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SvecBuilder setRequestsIds(List<RequestId> value) {
        this._requestsIds = value;
        return this;
    }

    public SvecBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public SvecBuilder setLinkDiverse(Boolean value) {
        this._linkDiverse = value;
        return this;
    }

    public SvecBuilder setNodeDiverse(Boolean value) {
        this._nodeDiverse = value;
        return this;
    }

    public SvecBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public SvecBuilder setSrlgDiverse(Boolean value) {
        this._srlgDiverse = value;
        return this;
    }

    public SvecBuilder addAugmentation(Class<? extends Augmentation<Svec>> augmentationType, Augmentation<Svec> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SvecBuilder removeAugmentation(Class<? extends Augmentation<Svec>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Svec build() {
        return new SvecImpl(this);
    }

    private static final class SvecImpl
    implements Svec {
        private final List<RequestId> _requestsIds;
        private final Boolean _ignore;
        private final Boolean _linkDiverse;
        private final Boolean _nodeDiverse;
        private final Boolean _processingRule;
        private final Boolean _srlgDiverse;
        private Map<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Svec> getImplementedInterface() {
            return Svec.class;
        }

        private SvecImpl(SvecBuilder base) {
            this._requestsIds = base.getRequestsIds();
            this._ignore = base.isIgnore();
            this._linkDiverse = base.isLinkDiverse();
            this._nodeDiverse = base.isNodeDiverse();
            this._processingRule = base.isProcessingRule();
            this._srlgDiverse = base.isSrlgDiverse();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Svec>>, Augmentation<Svec>>(base.augmentation);
                }
            }
        }

        @Override
        public List<RequestId> getRequestsIds() {
            return this._requestsIds;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isLinkDiverse() {
            return this._linkDiverse;
        }

        @Override
        public Boolean isNodeDiverse() {
            return this._nodeDiverse;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isSrlgDiverse() {
            return this._srlgDiverse;
        }

        @Override
        public <E extends Augmentation<Svec>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._requestsIds);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._linkDiverse);
            result = 31 * result + Objects.hashCode(this._nodeDiverse);
            result = 31 * result + Objects.hashCode(this._processingRule);
            result = 31 * result + Objects.hashCode(this._srlgDiverse);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Svec.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Svec other = (Svec)obj;
            if (!Objects.equals(this._requestsIds, other.getRequestsIds())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._linkDiverse, other.isLinkDiverse())) {
                return false;
            }
            if (!Objects.equals(this._nodeDiverse, other.isNodeDiverse())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(this._srlgDiverse, other.isSrlgDiverse())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SvecImpl otherImpl = (SvecImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Svec>>, Augmentation<Svec>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Svec [";
            StringBuilder builder = new StringBuilder(name);
            if (this._requestsIds != null) {
                builder.append("_requestsIds=");
                builder.append(this._requestsIds);
                builder.append(", ");
            }
            if (this._ignore != null) {
                builder.append("_ignore=");
                builder.append(this._ignore);
                builder.append(", ");
            }
            if (this._linkDiverse != null) {
                builder.append("_linkDiverse=");
                builder.append(this._linkDiverse);
                builder.append(", ");
            }
            if (this._nodeDiverse != null) {
                builder.append("_nodeDiverse=");
                builder.append(this._nodeDiverse);
                builder.append(", ");
            }
            if (this._processingRule != null) {
                builder.append("_processingRule=");
                builder.append(this._processingRule);
                builder.append(", ");
            }
            if (this._srlgDiverse != null) {
                builder.append("_srlgDiverse=");
                builder.append(this._srlgDiverse);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

