/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public enum ServiceNumber {
    Guaranteed(2, "guaranteed"),
    ControlledLoad(5, "controlled-load");

    private static final Map<Integer, ServiceNumber> VALUE_MAP;
    private final String name;
    private final int value;

    private ServiceNumber(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static ServiceNumber forValue(int valueArg) {
        return VALUE_MAP.get(valueArg);
    }

    static {
        ImmutableMap.Builder<Integer, ServiceNumber> b = ImmutableMap.builder();
        for (ServiceNumber enumItem : ServiceNumber.values()) {
            b.put(enumItem.value, enumItem);
        }
        VALUE_MAP = b.build();
    }
}

