/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.fast.reroute.object.fast.reroute.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CommonFastRerouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.FastRerouteFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.fast.reroute.object.fast.reroute.object.BasicFastRerouteObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BasicFastRerouteObjectBuilder
implements Builder<BasicFastRerouteObject> {
    private Bandwidth _bandwidth;
    private AttributeFilter _excludeAny;
    private FastRerouteFlags _flags;
    private Short _holdPriority;
    private Short _hopLimit;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private Short _setupPriority;
    Map<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>> augmentation = Collections.emptyMap();

    public BasicFastRerouteObjectBuilder() {
    }

    public BasicFastRerouteObjectBuilder(CommonFastRerouteObject arg) {
        this._hopLimit = arg.getHopLimit();
        this._flags = arg.getFlags();
        this._bandwidth = arg.getBandwidth();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public BasicFastRerouteObjectBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public BasicFastRerouteObjectBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public BasicFastRerouteObjectBuilder(BasicFastRerouteObject base) {
        AugmentationHolder casted;
        this._bandwidth = base.getBandwidth();
        this._excludeAny = base.getExcludeAny();
        this._flags = base.getFlags();
        this._holdPriority = base.getHoldPriority();
        this._hopLimit = base.getHopLimit();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._setupPriority = base.getSetupPriority();
        if (base instanceof BasicFastRerouteObjectImpl) {
            BasicFastRerouteObjectImpl impl = (BasicFastRerouteObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof CommonFastRerouteObject) {
            this._hopLimit = ((CommonFastRerouteObject)arg).getHopLimit();
            this._flags = ((CommonFastRerouteObject)arg).getFlags();
            this._bandwidth = ((CommonFastRerouteObject)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.CommonFastRerouteObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority] \nbut was: " + arg);
        }
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public FastRerouteFlags getFlags() {
        return this._flags;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public Short getHopLimit() {
        return this._hopLimit;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public <E extends Augmentation<BasicFastRerouteObject>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public BasicFastRerouteObjectBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setFlags(FastRerouteFlags value) {
        this._flags = value;
        return this;
    }

    private static void checkHoldPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public BasicFastRerouteObjectBuilder setHoldPriority(Short value) {
        if (value != null) {
            BasicFastRerouteObjectBuilder.checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }

    private static void checkHopLimitRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public BasicFastRerouteObjectBuilder setHopLimit(Short value) {
        if (value != null) {
            BasicFastRerouteObjectBuilder.checkHopLimitRange(value);
        }
        this._hopLimit = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    private static void checkSetupPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public BasicFastRerouteObjectBuilder setSetupPriority(Short value) {
        if (value != null) {
            BasicFastRerouteObjectBuilder.checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }

    public BasicFastRerouteObjectBuilder addAugmentation(Class<? extends Augmentation<BasicFastRerouteObject>> augmentationType, Augmentation<BasicFastRerouteObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public BasicFastRerouteObjectBuilder removeAugmentation(Class<? extends Augmentation<BasicFastRerouteObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BasicFastRerouteObject build() {
        return new BasicFastRerouteObjectImpl(this);
    }

    private static final class BasicFastRerouteObjectImpl
    implements BasicFastRerouteObject {
        private final Bandwidth _bandwidth;
        private final AttributeFilter _excludeAny;
        private final FastRerouteFlags _flags;
        private final Short _holdPriority;
        private final Short _hopLimit;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final Short _setupPriority;
        private Map<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<BasicFastRerouteObject> getImplementedInterface() {
            return BasicFastRerouteObject.class;
        }

        private BasicFastRerouteObjectImpl(BasicFastRerouteObjectBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._excludeAny = base.getExcludeAny();
            this._flags = base.getFlags();
            this._holdPriority = base.getHoldPriority();
            this._hopLimit = base.getHopLimit();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._setupPriority = base.getSetupPriority();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>>(base.augmentation);
                }
            }
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        @Override
        public FastRerouteFlags getFlags() {
            return this._flags;
        }

        @Override
        public Short getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public Short getHopLimit() {
            return this._hopLimit;
        }

        @Override
        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        @Override
        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        @Override
        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public <E extends Augmentation<BasicFastRerouteObject>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._excludeAny);
            result = 31 * result + Objects.hashCode((Object)this._flags);
            result = 31 * result + Objects.hashCode(this._holdPriority);
            result = 31 * result + Objects.hashCode(this._hopLimit);
            result = 31 * result + Objects.hashCode(this._includeAll);
            result = 31 * result + Objects.hashCode(this._includeAny);
            result = 31 * result + Objects.hashCode(this._setupPriority);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BasicFastRerouteObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BasicFastRerouteObject other = (BasicFastRerouteObject)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals((Object)this._flags, (Object)other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(this._hopLimit, other.getHopLimit())) {
                return false;
            }
            if (!Objects.equals(this._includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(this._includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(this._setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                BasicFastRerouteObjectImpl otherImpl = (BasicFastRerouteObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<BasicFastRerouteObject>>, Augmentation<BasicFastRerouteObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "BasicFastRerouteObject [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bandwidth != null) {
                builder.append("_bandwidth=");
                builder.append(this._bandwidth);
                builder.append(", ");
            }
            if (this._excludeAny != null) {
                builder.append("_excludeAny=");
                builder.append(this._excludeAny);
                builder.append(", ");
            }
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append((Object)this._flags);
                builder.append(", ");
            }
            if (this._holdPriority != null) {
                builder.append("_holdPriority=");
                builder.append(this._holdPriority);
                builder.append(", ");
            }
            if (this._hopLimit != null) {
                builder.append("_hopLimit=");
                builder.append(this._hopLimit);
                builder.append(", ");
            }
            if (this._includeAll != null) {
                builder.append("_includeAll=");
                builder.append(this._includeAll);
                builder.append(", ");
            }
            if (this._includeAny != null) {
                builder.append("_includeAny=");
                builder.append(this._includeAny);
                builder.append(", ");
            }
            if (this._setupPriority != null) {
                builder.append("_setupPriority=");
                builder.append(this._setupPriority);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

