/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ServiceNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.flow.spec.object.FlowSpecObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowSpecObjectBuilder
implements Builder<FlowSpecObject> {
    private Float32 _rate;
    private ServiceNumber _serviceHeader;
    private Long _slackTerm;
    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject _tspecObject;
    Map<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>> augmentation = Collections.emptyMap();

    public FlowSpecObjectBuilder() {
    }

    public FlowSpecObjectBuilder(TspecObject arg) {
        this._tspecObject = arg.getTspecObject();
    }

    public FlowSpecObjectBuilder(FlowSpecObject base) {
        AugmentationHolder casted;
        this._rate = base.getRate();
        this._serviceHeader = base.getServiceHeader();
        this._slackTerm = base.getSlackTerm();
        this._tspecObject = base.getTspecObject();
        if (base instanceof FlowSpecObjectImpl) {
            FlowSpecObjectImpl impl = (FlowSpecObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TspecObject) {
            this._tspecObject = ((TspecObject)arg).getTspecObject();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TspecObject] \nbut was: " + arg);
        }
    }

    public Float32 getRate() {
        return this._rate;
    }

    public ServiceNumber getServiceHeader() {
        return this._serviceHeader;
    }

    public Long getSlackTerm() {
        return this._slackTerm;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject getTspecObject() {
        return this._tspecObject;
    }

    public <E extends Augmentation<FlowSpecObject>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public FlowSpecObjectBuilder setRate(Float32 value) {
        this._rate = value;
        return this;
    }

    public FlowSpecObjectBuilder setServiceHeader(ServiceNumber value) {
        this._serviceHeader = value;
        return this;
    }

    private static void checkSlackTermRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public FlowSpecObjectBuilder setSlackTerm(Long value) {
        if (value != null) {
            FlowSpecObjectBuilder.checkSlackTermRange(value);
        }
        this._slackTerm = value;
        return this;
    }

    public FlowSpecObjectBuilder setTspecObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject value) {
        this._tspecObject = value;
        return this;
    }

    public FlowSpecObjectBuilder addAugmentation(Class<? extends Augmentation<FlowSpecObject>> augmentationType, Augmentation<FlowSpecObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FlowSpecObjectBuilder removeAugmentation(Class<? extends Augmentation<FlowSpecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowSpecObject build() {
        return new FlowSpecObjectImpl(this);
    }

    private static final class FlowSpecObjectImpl
    implements FlowSpecObject {
        private final Float32 _rate;
        private final ServiceNumber _serviceHeader;
        private final Long _slackTerm;
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject _tspecObject;
        private Map<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowSpecObject> getImplementedInterface() {
            return FlowSpecObject.class;
        }

        private FlowSpecObjectImpl(FlowSpecObjectBuilder base) {
            this._rate = base.getRate();
            this._serviceHeader = base.getServiceHeader();
            this._slackTerm = base.getSlackTerm();
            this._tspecObject = base.getTspecObject();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>>(base.augmentation);
                }
            }
        }

        @Override
        public Float32 getRate() {
            return this._rate;
        }

        @Override
        public ServiceNumber getServiceHeader() {
            return this._serviceHeader;
        }

        @Override
        public Long getSlackTerm() {
            return this._slackTerm;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject getTspecObject() {
            return this._tspecObject;
        }

        @Override
        public <E extends Augmentation<FlowSpecObject>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._rate);
            result = 31 * result + Objects.hashCode((Object)this._serviceHeader);
            result = 31 * result + Objects.hashCode(this._slackTerm);
            result = 31 * result + Objects.hashCode(this._tspecObject);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowSpecObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowSpecObject other = (FlowSpecObject)obj;
            if (!Objects.equals(this._rate, other.getRate())) {
                return false;
            }
            if (!Objects.equals((Object)this._serviceHeader, (Object)other.getServiceHeader())) {
                return false;
            }
            if (!Objects.equals(this._slackTerm, other.getSlackTerm())) {
                return false;
            }
            if (!Objects.equals(this._tspecObject, other.getTspecObject())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowSpecObjectImpl otherImpl = (FlowSpecObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowSpecObject>>, Augmentation<FlowSpecObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlowSpecObject [";
            StringBuilder builder = new StringBuilder(name);
            if (this._rate != null) {
                builder.append("_rate=");
                builder.append(this._rate);
                builder.append(", ");
            }
            if (this._serviceHeader != null) {
                builder.append("_serviceHeader=");
                builder.append((Object)this._serviceHeader);
                builder.append(", ");
            }
            if (this._slackTerm != null) {
                builder.append("_slackTerm=");
                builder.append(this._slackTerm);
                builder.append(", ");
            }
            if (this._tspecObject != null) {
                builder.append("_tspecObject=");
                builder.append(this._tspecObject);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

