/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.list;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.list.SubobjectContainer;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SubobjectContainerBuilder
implements Builder<SubobjectContainer> {
    private SubobjectType _subobjectType;
    private Boolean _protectionAvailable;
    private Boolean _protectionInUse;
    Map<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>> augmentation = Collections.emptyMap();

    public SubobjectContainerBuilder() {
    }

    public SubobjectContainerBuilder(RecordRouteSubobjects arg) {
        this._protectionAvailable = arg.isProtectionAvailable();
        this._protectionInUse = arg.isProtectionInUse();
        this._subobjectType = arg.getSubobjectType();
    }

    public SubobjectContainerBuilder(SubobjectContainer base) {
        AugmentationHolder casted;
        this._subobjectType = base.getSubobjectType();
        this._protectionAvailable = base.isProtectionAvailable();
        this._protectionInUse = base.isProtectionInUse();
        if (base instanceof SubobjectContainerImpl) {
            SubobjectContainerImpl impl = (SubobjectContainerImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof RecordRouteSubobjects) {
            this._protectionAvailable = ((RecordRouteSubobjects)arg).isProtectionAvailable();
            this._protectionInUse = ((RecordRouteSubobjects)arg).isProtectionInUse();
            this._subobjectType = ((RecordRouteSubobjects)arg).getSubobjectType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.RecordRouteSubobjects] \nbut was: " + arg);
        }
    }

    public SubobjectType getSubobjectType() {
        return this._subobjectType;
    }

    public Boolean isProtectionAvailable() {
        return this._protectionAvailable;
    }

    public Boolean isProtectionInUse() {
        return this._protectionInUse;
    }

    public <E extends Augmentation<SubobjectContainer>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SubobjectContainerBuilder setSubobjectType(SubobjectType value) {
        this._subobjectType = value;
        return this;
    }

    public SubobjectContainerBuilder setProtectionAvailable(Boolean value) {
        this._protectionAvailable = value;
        return this;
    }

    public SubobjectContainerBuilder setProtectionInUse(Boolean value) {
        this._protectionInUse = value;
        return this;
    }

    public SubobjectContainerBuilder addAugmentation(Class<? extends Augmentation<SubobjectContainer>> augmentationType, Augmentation<SubobjectContainer> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SubobjectContainerBuilder removeAugmentation(Class<? extends Augmentation<SubobjectContainer>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SubobjectContainer build() {
        return new SubobjectContainerImpl(this);
    }

    private static final class SubobjectContainerImpl
    implements SubobjectContainer {
        private final SubobjectType _subobjectType;
        private final Boolean _protectionAvailable;
        private final Boolean _protectionInUse;
        private Map<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SubobjectContainer> getImplementedInterface() {
            return SubobjectContainer.class;
        }

        private SubobjectContainerImpl(SubobjectContainerBuilder base) {
            this._subobjectType = base.getSubobjectType();
            this._protectionAvailable = base.isProtectionAvailable();
            this._protectionInUse = base.isProtectionInUse();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>>(base.augmentation);
                }
            }
        }

        @Override
        public SubobjectType getSubobjectType() {
            return this._subobjectType;
        }

        @Override
        public Boolean isProtectionAvailable() {
            return this._protectionAvailable;
        }

        @Override
        public Boolean isProtectionInUse() {
            return this._protectionInUse;
        }

        @Override
        public <E extends Augmentation<SubobjectContainer>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._subobjectType);
            result = 31 * result + Objects.hashCode(this._protectionAvailable);
            result = 31 * result + Objects.hashCode(this._protectionInUse);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SubobjectContainer.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SubobjectContainer other = (SubobjectContainer)obj;
            if (!Objects.equals(this._subobjectType, other.getSubobjectType())) {
                return false;
            }
            if (!Objects.equals(this._protectionAvailable, other.isProtectionAvailable())) {
                return false;
            }
            if (!Objects.equals(this._protectionInUse, other.isProtectionInUse())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SubobjectContainerImpl otherImpl = (SubobjectContainerImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SubobjectContainer>>, Augmentation<SubobjectContainer>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SubobjectContainer [";
            StringBuilder builder = new StringBuilder(name);
            if (this._subobjectType != null) {
                builder.append("_subobjectType=");
                builder.append(this._subobjectType);
                builder.append(", ");
            }
            if (this._protectionAvailable != null) {
                builder.append("_protectionAvailable=");
                builder.append(this._protectionAvailable);
                builder.append(", ");
            }
            if (this._protectionInUse != null) {
                builder.append("_protectionInUse=");
                builder.append(this._protectionInUse);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

