/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.label._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LabelSubobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.label._case.Label;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class LabelBuilder
implements Builder<Label> {
    private LabelType _labelType;
    private Boolean _global;
    private Boolean _uniDirectional;
    Map<Class<? extends Augmentation<Label>>, Augmentation<Label>> augmentation = Collections.emptyMap();

    public LabelBuilder() {
    }

    public LabelBuilder(LabelSubobject arg) {
        this._uniDirectional = arg.isUniDirectional();
        this._labelType = arg.getLabelType();
    }

    public LabelBuilder(Label base) {
        AugmentationHolder casted;
        this._labelType = base.getLabelType();
        this._global = base.isGlobal();
        this._uniDirectional = base.isUniDirectional();
        if (base instanceof LabelImpl) {
            LabelImpl impl = (LabelImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Label>>, Augmentation<Label>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LabelSubobject) {
            this._uniDirectional = ((LabelSubobject)arg).isUniDirectional();
            this._labelType = ((LabelSubobject)arg).getLabelType();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LabelSubobject] \nbut was: " + arg);
        }
    }

    public LabelType getLabelType() {
        return this._labelType;
    }

    public Boolean isGlobal() {
        return this._global;
    }

    public Boolean isUniDirectional() {
        return this._uniDirectional;
    }

    public <E extends Augmentation<Label>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public LabelBuilder setLabelType(LabelType value) {
        this._labelType = value;
        return this;
    }

    public LabelBuilder setGlobal(Boolean value) {
        this._global = value;
        return this;
    }

    public LabelBuilder setUniDirectional(Boolean value) {
        this._uniDirectional = value;
        return this;
    }

    public LabelBuilder addAugmentation(Class<? extends Augmentation<Label>> augmentationType, Augmentation<Label> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Label>>, Augmentation<Label>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public LabelBuilder removeAugmentation(Class<? extends Augmentation<Label>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Label build() {
        return new LabelImpl(this);
    }

    private static final class LabelImpl
    implements Label {
        private final LabelType _labelType;
        private final Boolean _global;
        private final Boolean _uniDirectional;
        private Map<Class<? extends Augmentation<Label>>, Augmentation<Label>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Label> getImplementedInterface() {
            return Label.class;
        }

        private LabelImpl(LabelBuilder base) {
            this._labelType = base.getLabelType();
            this._global = base.isGlobal();
            this._uniDirectional = base.isUniDirectional();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Label>>, Augmentation<Label>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Label>>, Augmentation<Label>>(base.augmentation);
                }
            }
        }

        @Override
        public LabelType getLabelType() {
            return this._labelType;
        }

        @Override
        public Boolean isGlobal() {
            return this._global;
        }

        @Override
        public Boolean isUniDirectional() {
            return this._uniDirectional;
        }

        @Override
        public <E extends Augmentation<Label>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._labelType);
            result = 31 * result + Objects.hashCode(this._global);
            result = 31 * result + Objects.hashCode(this._uniDirectional);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Label.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Label other = (Label)obj;
            if (!Objects.equals(this._labelType, other.getLabelType())) {
                return false;
            }
            if (!Objects.equals(this._global, other.isGlobal())) {
                return false;
            }
            if (!Objects.equals(this._uniDirectional, other.isUniDirectional())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                LabelImpl otherImpl = (LabelImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Label>>, Augmentation<Label>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Label [";
            StringBuilder builder = new StringBuilder(name);
            if (this._labelType != null) {
                builder.append("_labelType=");
                builder.append(this._labelType);
                builder.append(", ");
            }
            if (this._global != null) {
                builder.append("_global=");
                builder.append(this._global);
                builder.append(", ");
            }
            if (this._uniDirectional != null) {
                builder.append("_uniDirectional=");
                builder.append(this._uniDirectional);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

