/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.InstructionId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.Nanotime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.programming.rev131030.PcepUpdateTunnelInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.LinkId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepUpdateTunnelInputBuilder
implements Builder<PcepUpdateTunnelInput> {
    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Nanotime _deadline;
    private AttributeFilter _excludeAny;
    private List<ExplicitHops> _explicitHops;
    private Short _holdPriority;
    private InstructionId _id;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private LinkId _linkId;
    private NetworkTopologyRef _networkTopologyRef;
    private List<InstructionId> _preconditions;
    private String _sessionName;
    private Short _setupPriority;
    private String _symbolicPathName;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _seStyleDesired;
    Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> augmentation = Collections.emptyMap();

    public PcepUpdateTunnelInputBuilder() {
    }

    public PcepUpdateTunnelInputBuilder(BaseTunnelInput arg) {
        this._linkId = arg.getLinkId();
        this._networkTopologyRef = arg.getNetworkTopologyRef();
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }

    public PcepUpdateTunnelInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }

    public PcepUpdateTunnelInputBuilder(SubmitInstructionInput arg) {
        this._id = arg.getId();
        this._deadline = arg.getDeadline();
        this._preconditions = arg.getPreconditions();
    }

    public PcepUpdateTunnelInputBuilder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public PcepUpdateTunnelInputBuilder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public PcepUpdateTunnelInputBuilder(TunnelP2pPathCfgAttributes arg) {
        this._explicitHops = arg.getExplicitHops();
    }

    public PcepUpdateTunnelInputBuilder(PcepUpdateTunnelInput base) {
        AugmentationHolder casted;
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._deadline = base.getDeadline();
        this._excludeAny = base.getExcludeAny();
        this._explicitHops = base.getExplicitHops();
        this._holdPriority = base.getHoldPriority();
        this._id = base.getId();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._linkId = base.getLinkId();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._preconditions = base.getPreconditions();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._seStyleDesired = base.isSeStyleDesired();
        if (base instanceof PcepUpdateTunnelInputImpl) {
            PcepUpdateTunnelInputImpl impl = (PcepUpdateTunnelInputImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NetworkTopologyReference) {
            this._networkTopologyRef = ((NetworkTopologyReference)arg).getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof SubmitInstructionInput) {
            this._id = ((SubmitInstructionInput)arg).getId();
            this._deadline = ((SubmitInstructionInput)arg).getDeadline();
            this._preconditions = ((SubmitInstructionInput)arg).getPreconditions();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof TunnelP2pPathCfgAttributes) {
            this._explicitHops = ((TunnelP2pPathCfgAttributes)arg).getExplicitHops();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        if (arg instanceof BaseTunnelInput) {
            this._linkId = ((BaseTunnelInput)arg).getLinkId();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.programming.rev150720.SubmitInstructionInput, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.BaseTunnelInput] \nbut was: " + arg);
        }
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public ClassType getClassType() {
        return this._classType;
    }

    public Nanotime getDeadline() {
        return this._deadline;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public List<ExplicitHops> getExplicitHops() {
        return this._explicitHops;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public InstructionId getId() {
        return this._id;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public LinkId getLinkId() {
        return this._linkId;
    }

    public NetworkTopologyRef getNetworkTopologyRef() {
        return this._networkTopologyRef;
    }

    public List<InstructionId> getPreconditions() {
        return this._preconditions;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public String getSymbolicPathName() {
        return this._symbolicPathName;
    }

    public Boolean isLabelRecordingDesired() {
        return this._labelRecordingDesired;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Boolean isSeStyleDesired() {
        return this._seStyleDesired;
    }

    public <E extends Augmentation<PcepUpdateTunnelInput>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public PcepUpdateTunnelInputBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setClassType(ClassType value) {
        this._classType = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setDeadline(Nanotime value) {
        this._deadline = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setExplicitHops(List<ExplicitHops> value) {
        this._explicitHops = value;
        return this;
    }

    private static void checkHoldPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public PcepUpdateTunnelInputBuilder setHoldPriority(Short value) {
        if (value != null) {
            PcepUpdateTunnelInputBuilder.checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setId(InstructionId value) {
        this._id = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setLinkId(LinkId value) {
        this._linkId = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setNetworkTopologyRef(NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setPreconditions(List<InstructionId> value) {
        this._preconditions = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setSessionName(String value) {
        this._sessionName = value;
        return this;
    }

    private static void checkSetupPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public PcepUpdateTunnelInputBuilder setSetupPriority(Short value) {
        if (value != null) {
            PcepUpdateTunnelInputBuilder.checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setSymbolicPathName(String value) {
        this._symbolicPathName = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setLabelRecordingDesired(Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder setSeStyleDesired(Boolean value) {
        this._seStyleDesired = value;
        return this;
    }

    public PcepUpdateTunnelInputBuilder addAugmentation(Class<? extends Augmentation<PcepUpdateTunnelInput>> augmentationType, Augmentation<PcepUpdateTunnelInput> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepUpdateTunnelInputBuilder removeAugmentation(Class<? extends Augmentation<PcepUpdateTunnelInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepUpdateTunnelInput build() {
        return new PcepUpdateTunnelInputImpl(this);
    }

    private static final class PcepUpdateTunnelInputImpl
    implements PcepUpdateTunnelInput {
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Nanotime _deadline;
        private final AttributeFilter _excludeAny;
        private final List<ExplicitHops> _explicitHops;
        private final Short _holdPriority;
        private final InstructionId _id;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final LinkId _linkId;
        private final NetworkTopologyRef _networkTopologyRef;
        private final List<InstructionId> _preconditions;
        private final String _sessionName;
        private final Short _setupPriority;
        private final String _symbolicPathName;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _seStyleDesired;
        private Map<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<PcepUpdateTunnelInput> getImplementedInterface() {
            return PcepUpdateTunnelInput.class;
        }

        private PcepUpdateTunnelInputImpl(PcepUpdateTunnelInputBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._deadline = base.getDeadline();
            this._excludeAny = base.getExcludeAny();
            this._explicitHops = base.getExplicitHops();
            this._holdPriority = base.getHoldPriority();
            this._id = base.getId();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._linkId = base.getLinkId();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._preconditions = base.getPreconditions();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._seStyleDesired = base.isSeStyleDesired();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>>(base.augmentation);
                }
            }
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public ClassType getClassType() {
            return this._classType;
        }

        @Override
        public Nanotime getDeadline() {
            return this._deadline;
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        @Override
        public List<ExplicitHops> getExplicitHops() {
            return this._explicitHops;
        }

        @Override
        public Short getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public InstructionId getId() {
            return this._id;
        }

        @Override
        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        @Override
        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        @Override
        public LinkId getLinkId() {
            return this._linkId;
        }

        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return this._networkTopologyRef;
        }

        @Override
        public List<InstructionId> getPreconditions() {
            return this._preconditions;
        }

        @Override
        public String getSessionName() {
            return this._sessionName;
        }

        @Override
        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public String getSymbolicPathName() {
            return this._symbolicPathName;
        }

        @Override
        public Boolean isLabelRecordingDesired() {
            return this._labelRecordingDesired;
        }

        @Override
        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        @Override
        public Boolean isSeStyleDesired() {
            return this._seStyleDesired;
        }

        @Override
        public <E extends Augmentation<PcepUpdateTunnelInput>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._classType);
            result = 31 * result + Objects.hashCode(this._deadline);
            result = 31 * result + Objects.hashCode(this._excludeAny);
            result = 31 * result + Objects.hashCode(this._explicitHops);
            result = 31 * result + Objects.hashCode(this._holdPriority);
            result = 31 * result + Objects.hashCode(this._id);
            result = 31 * result + Objects.hashCode(this._includeAll);
            result = 31 * result + Objects.hashCode(this._includeAny);
            result = 31 * result + Objects.hashCode(this._linkId);
            result = 31 * result + Objects.hashCode(this._networkTopologyRef);
            result = 31 * result + Objects.hashCode(this._preconditions);
            result = 31 * result + Objects.hashCode(this._sessionName);
            result = 31 * result + Objects.hashCode(this._setupPriority);
            result = 31 * result + Objects.hashCode(this._symbolicPathName);
            result = 31 * result + Objects.hashCode(this._labelRecordingDesired);
            result = 31 * result + Objects.hashCode(this._localProtectionDesired);
            result = 31 * result + Objects.hashCode(this._seStyleDesired);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepUpdateTunnelInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepUpdateTunnelInput other = (PcepUpdateTunnelInput)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._classType, other.getClassType())) {
                return false;
            }
            if (!Objects.equals(this._deadline, other.getDeadline())) {
                return false;
            }
            if (!Objects.equals(this._excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(this._explicitHops, other.getExplicitHops())) {
                return false;
            }
            if (!Objects.equals(this._holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(this._id, other.getId())) {
                return false;
            }
            if (!Objects.equals(this._includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(this._includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(this._linkId, other.getLinkId())) {
                return false;
            }
            if (!Objects.equals(this._networkTopologyRef, other.getNetworkTopologyRef())) {
                return false;
            }
            if (!Objects.equals(this._preconditions, other.getPreconditions())) {
                return false;
            }
            if (!Objects.equals(this._sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(this._setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(this._symbolicPathName, other.getSymbolicPathName())) {
                return false;
            }
            if (!Objects.equals(this._labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(this._localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            if (!Objects.equals(this._seStyleDesired, other.isSeStyleDesired())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepUpdateTunnelInputImpl otherImpl = (PcepUpdateTunnelInputImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepUpdateTunnelInput>>, Augmentation<PcepUpdateTunnelInput>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "PcepUpdateTunnelInput [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bandwidth != null) {
                builder.append("_bandwidth=");
                builder.append(this._bandwidth);
                builder.append(", ");
            }
            if (this._classType != null) {
                builder.append("_classType=");
                builder.append(this._classType);
                builder.append(", ");
            }
            if (this._deadline != null) {
                builder.append("_deadline=");
                builder.append(this._deadline);
                builder.append(", ");
            }
            if (this._excludeAny != null) {
                builder.append("_excludeAny=");
                builder.append(this._excludeAny);
                builder.append(", ");
            }
            if (this._explicitHops != null) {
                builder.append("_explicitHops=");
                builder.append(this._explicitHops);
                builder.append(", ");
            }
            if (this._holdPriority != null) {
                builder.append("_holdPriority=");
                builder.append(this._holdPriority);
                builder.append(", ");
            }
            if (this._id != null) {
                builder.append("_id=");
                builder.append(this._id);
                builder.append(", ");
            }
            if (this._includeAll != null) {
                builder.append("_includeAll=");
                builder.append(this._includeAll);
                builder.append(", ");
            }
            if (this._includeAny != null) {
                builder.append("_includeAny=");
                builder.append(this._includeAny);
                builder.append(", ");
            }
            if (this._linkId != null) {
                builder.append("_linkId=");
                builder.append(this._linkId);
                builder.append(", ");
            }
            if (this._networkTopologyRef != null) {
                builder.append("_networkTopologyRef=");
                builder.append(this._networkTopologyRef);
                builder.append(", ");
            }
            if (this._preconditions != null) {
                builder.append("_preconditions=");
                builder.append(this._preconditions);
                builder.append(", ");
            }
            if (this._sessionName != null) {
                builder.append("_sessionName=");
                builder.append(this._sessionName);
                builder.append(", ");
            }
            if (this._setupPriority != null) {
                builder.append("_setupPriority=");
                builder.append(this._setupPriority);
                builder.append(", ");
            }
            if (this._symbolicPathName != null) {
                builder.append("_symbolicPathName=");
                builder.append(this._symbolicPathName);
                builder.append(", ");
            }
            if (this._labelRecordingDesired != null) {
                builder.append("_labelRecordingDesired=");
                builder.append(this._labelRecordingDesired);
                builder.append(", ");
            }
            if (this._localProtectionDesired != null) {
                builder.append("_localProtectionDesired=");
                builder.append(this._localProtectionDesired);
                builder.append(", ");
            }
            if (this._seStyleDesired != null) {
                builder.append("_seStyleDesired=");
                builder.append(this._seStyleDesired);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

