/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.create.p2p.tunnel.input.Destination;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DestinationBuilder
implements Builder<Destination> {
    private NodeId _node;
    private TpId _tp;
    Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();

    public DestinationBuilder() {
    }

    public DestinationBuilder(TpReference arg) {
        this._node = arg.getNode();
        this._tp = arg.getTp();
    }

    public DestinationBuilder(Destination base) {
        AugmentationHolder casted;
        this._node = base.getNode();
        this._tp = base.getTp();
        if (base instanceof DestinationImpl) {
            DestinationImpl impl = (DestinationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TpReference) {
            this._node = ((TpReference)arg).getNode();
            this._tp = ((TpReference)arg).getTp();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.programming.rev130930.TpReference] \nbut was: " + arg);
        }
    }

    public NodeId getNode() {
        return this._node;
    }

    public TpId getTp() {
        return this._tp;
    }

    public <E extends Augmentation<Destination>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DestinationBuilder setNode(NodeId value) {
        this._node = value;
        return this;
    }

    public DestinationBuilder setTp(TpId value) {
        this._tp = value;
        return this;
    }

    public DestinationBuilder addAugmentation(Class<? extends Augmentation<Destination>> augmentationType, Augmentation<Destination> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public DestinationBuilder removeAugmentation(Class<? extends Augmentation<Destination>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Destination build() {
        return new DestinationImpl(this);
    }

    private static final class DestinationImpl
    implements Destination {
        private final NodeId _node;
        private final TpId _tp;
        private Map<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Destination> getImplementedInterface() {
            return Destination.class;
        }

        private DestinationImpl(DestinationBuilder base) {
            this._node = base.getNode();
            this._tp = base.getTp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Destination>>, Augmentation<Destination>>(base.augmentation);
                }
            }
        }

        @Override
        public NodeId getNode() {
            return this._node;
        }

        @Override
        public TpId getTp() {
            return this._tp;
        }

        @Override
        public <E extends Augmentation<Destination>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._tp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Destination.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Destination other = (Destination)obj;
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._tp, other.getTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DestinationImpl otherImpl = (DestinationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Destination>>, Augmentation<Destination>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Destination [";
            StringBuilder builder = new StringBuilder(name);
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._tp != null) {
                builder.append("_tp=");
                builder.append(this._tp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

