/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.link.attributes.Source;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SourceBuilder
implements Builder<Source> {
    private NodeId _sourceNode;
    private TpId _sourceTp;
    Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();

    public SourceBuilder() {
    }

    public SourceBuilder(Source base) {
        AugmentationHolder casted;
        this._sourceNode = base.getSourceNode();
        this._sourceTp = base.getSourceTp();
        if (base instanceof SourceImpl) {
            SourceImpl impl = (SourceImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public NodeId getSourceNode() {
        return this._sourceNode;
    }

    public TpId getSourceTp() {
        return this._sourceTp;
    }

    public <E extends Augmentation<Source>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SourceBuilder setSourceNode(NodeId value) {
        this._sourceNode = value;
        return this;
    }

    public SourceBuilder setSourceTp(TpId value) {
        this._sourceTp = value;
        return this;
    }

    public SourceBuilder addAugmentation(Class<? extends Augmentation<Source>> augmentationType, Augmentation<Source> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SourceBuilder removeAugmentation(Class<? extends Augmentation<Source>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    implements Source {
        private final NodeId _sourceNode;
        private final TpId _sourceTp;
        private Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Source> getImplementedInterface() {
            return Source.class;
        }

        private SourceImpl(SourceBuilder base) {
            this._sourceNode = base.getSourceNode();
            this._sourceTp = base.getSourceTp();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Source>>, Augmentation<Source>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(base.augmentation);
                }
            }
        }

        @Override
        public NodeId getSourceNode() {
            return this._sourceNode;
        }

        @Override
        public TpId getSourceTp() {
            return this._sourceTp;
        }

        @Override
        public <E extends Augmentation<Source>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._sourceNode);
            result = 31 * result + Objects.hashCode(this._sourceTp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Source.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Source other = (Source)obj;
            if (!Objects.equals(this._sourceNode, other.getSourceNode())) {
                return false;
            }
            if (!Objects.equals(this._sourceTp, other.getSourceTp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SourceImpl otherImpl = (SourceImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Source>>, Augmentation<Source>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Source [";
            StringBuilder builder = new StringBuilder(name);
            if (this._sourceNode != null) {
                builder.append("_sourceNode=");
                builder.append(this._sourceNode);
                builder.append(", ");
            }
            if (this._sourceTp != null) {
                builder.append("_sourceTp=");
                builder.append(this._sourceTp);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

