/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.Link;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.TopologyTypes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev130712.network.topology.topology.UnderlayTopology;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TopologyBuilder
implements Builder<Topology> {
    private TopologyKey _key;
    private List<Link> _link;
    private List<Node> _node;
    private TopologyId _topologyId;
    private TopologyTypes _topologyTypes;
    private List<UnderlayTopology> _underlayTopology;
    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Collections.emptyMap();

    public TopologyBuilder() {
    }

    public TopologyBuilder(Topology base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new TopologyKey(base.getTopologyId());
            this._topologyId = base.getTopologyId();
        } else {
            this._key = base.getKey();
            this._topologyId = this._key.getTopologyId();
        }
        this._link = base.getLink();
        this._node = base.getNode();
        this._topologyTypes = base.getTopologyTypes();
        this._underlayTopology = base.getUnderlayTopology();
        if (base instanceof TopologyImpl) {
            TopologyImpl impl = (TopologyImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public TopologyKey getKey() {
        return this._key;
    }

    public List<Link> getLink() {
        return this._link;
    }

    public List<Node> getNode() {
        return this._node;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public TopologyTypes getTopologyTypes() {
        return this._topologyTypes;
    }

    public List<UnderlayTopology> getUnderlayTopology() {
        return this._underlayTopology;
    }

    public <E extends Augmentation<Topology>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public TopologyBuilder setKey(TopologyKey value) {
        this._key = value;
        return this;
    }

    public TopologyBuilder setLink(List<Link> value) {
        this._link = value;
        return this;
    }

    public TopologyBuilder setNode(List<Node> value) {
        this._node = value;
        return this;
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder setTopologyTypes(TopologyTypes value) {
        this._topologyTypes = value;
        return this;
    }

    public TopologyBuilder setUnderlayTopology(List<UnderlayTopology> value) {
        this._underlayTopology = value;
        return this;
    }

    public TopologyBuilder addAugmentation(Class<? extends Augmentation<Topology>> augmentationType, Augmentation<Topology> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    implements Topology {
        private final TopologyKey _key;
        private final List<Link> _link;
        private final List<Node> _node;
        private final TopologyId _topologyId;
        private final TopologyTypes _topologyTypes;
        private final List<UnderlayTopology> _underlayTopology;
        private Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Topology> getImplementedInterface() {
            return Topology.class;
        }

        private TopologyImpl(TopologyBuilder base) {
            if (base.getKey() == null) {
                this._key = new TopologyKey(base.getTopologyId());
                this._topologyId = base.getTopologyId();
            } else {
                this._key = base.getKey();
                this._topologyId = this._key.getTopologyId();
            }
            this._link = base.getLink();
            this._node = base.getNode();
            this._topologyTypes = base.getTopologyTypes();
            this._underlayTopology = base.getUnderlayTopology();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>(base.augmentation);
                }
            }
        }

        @Override
        public TopologyKey getKey() {
            return this._key;
        }

        @Override
        public List<Link> getLink() {
            return this._link;
        }

        @Override
        public List<Node> getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        @Override
        public TopologyTypes getTopologyTypes() {
            return this._topologyTypes;
        }

        @Override
        public List<UnderlayTopology> getUnderlayTopology() {
            return this._underlayTopology;
        }

        @Override
        public <E extends Augmentation<Topology>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._link);
            result = 31 * result + Objects.hashCode(this._node);
            result = 31 * result + Objects.hashCode(this._topologyId);
            result = 31 * result + Objects.hashCode(this._topologyTypes);
            result = 31 * result + Objects.hashCode(this._underlayTopology);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Topology.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Topology other = (Topology)obj;
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._link, other.getLink())) {
                return false;
            }
            if (!Objects.equals(this._node, other.getNode())) {
                return false;
            }
            if (!Objects.equals(this._topologyId, other.getTopologyId())) {
                return false;
            }
            if (!Objects.equals(this._topologyTypes, other.getTopologyTypes())) {
                return false;
            }
            if (!Objects.equals(this._underlayTopology, other.getUnderlayTopology())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TopologyImpl otherImpl = (TopologyImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Topology [";
            StringBuilder builder = new StringBuilder(name);
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._link != null) {
                builder.append("_link=");
                builder.append(this._link);
                builder.append(", ");
            }
            if (this._node != null) {
                builder.append("_node=");
                builder.append(this._node);
                builder.append(", ");
            }
            if (this._topologyId != null) {
                builder.append("_topologyId=");
                builder.append(this._topologyId);
                builder.append(", ");
            }
            if (this._topologyTypes != null) {
                builder.append("_topologyTypes=");
                builder.append(this._topologyTypes);
                builder.append(", ");
            }
            if (this._underlayTopology != null) {
                builder.append("_underlayTopology=");
                builder.append(this._underlayTopology);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

