/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import org.opendaylight.yangtools.triemap.TrieMap;

abstract class AbstractKeySet<K>
extends AbstractSet<K> {
    private final TrieMap<K, ?> map;

    AbstractKeySet(TrieMap<K, ?> map) {
        this.map = Objects.requireNonNull(map);
    }

    final TrieMap<K, ?> map() {
        return this.map;
    }

    @Override
    public final boolean add(K e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean addAll(Collection<? extends K> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final Spliterator<K> spliterator() {
        return Spliterators.spliterator(Iterators.transform(this.map().immutableIterator(), Map.Entry::getKey), Long.MAX_VALUE, this.spliteratorCharacteristics());
    }

    abstract int spliteratorCharacteristics();
}

