/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.triemap;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.yangtools.triemap.AbstractEntrySet;
import org.opendaylight.yangtools.triemap.TrieMap;

final class MutableEntrySet<K, V>
extends AbstractEntrySet<K, V> {
    MutableEntrySet(TrieMap<K, V> map) {
        super(map);
    }

    @Override
    public boolean add(Map.Entry<K, V> e) {
        K k = e.getKey();
        Preconditions.checkArgument(k != null);
        V v = e.getValue();
        Preconditions.checkArgument(v != null);
        Object prev = this.map().putIfAbsent(k, v);
        return prev == null || !v.equals(prev);
    }

    @Override
    public void clear() {
        this.map().clear();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return this.map().iterator();
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        Map.Entry e = (Map.Entry)o;
        Object key = e.getKey();
        if (key == null) {
            return false;
        }
        Object value = e.getValue();
        if (value == null) {
            return false;
        }
        return this.map().remove(key, value);
    }

    @Override
    int characteristics() {
        return 4353;
    }
}

