/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@ThreadSafe
public final class RecursiveObjectLeaker {
    private static final Logger LOG = LoggerFactory.getLogger(RecursiveObjectLeaker.class);
    private static final ThreadLocal<Deque<Map.Entry<?, Object>>> STACK = new ThreadLocal();

    private RecursiveObjectLeaker() {
        throw new UnsupportedOperationException();
    }

    public static void beforeConstructor(Object key) {
        Deque<Map.Entry<?, Object>> stack = STACK.get();
        if (stack == null) {
            stack = new ArrayDeque(1);
            STACK.set(stack);
        }
        LOG.debug("Resolving key {}", key);
        stack.push(new AbstractMap.SimpleEntry<Object, Object>(key, null));
    }

    public static void inConstructor(Object obj) {
        Deque<Map.Entry<?, Object>> stack = STACK.get();
        if (stack != null) {
            Map.Entry<?, Object> top = stack.peek();
            if (top != null) {
                if (top.getValue() == null) {
                    LOG.debug("Resolved key {}", top.getKey());
                    top.setValue(obj);
                }
            } else {
                LOG.info("Cleaned stale empty stack", new Exception());
                STACK.set(null);
            }
        } else {
            LOG.trace("No thread stack");
        }
    }

    public static void afterConstructor(Object key) {
        Deque<Map.Entry<?, Object>> stack = STACK.get();
        Preconditions.checkState(stack != null, "No stack allocated when completing %s", key);
        Map.Entry<?, Object> top = stack.pop();
        if (stack.isEmpty()) {
            LOG.trace("Removed empty thread stack");
            STACK.set(null);
        }
        Preconditions.checkState(key == top.getKey(), "Expected key %s, have %s", top.getKey(), key);
        Preconditions.checkState(top.getValue() != null, "");
    }

    @Nullable
    public static <T> T lookup(Object key, Class<T> requiredClass) {
        Deque<Map.Entry<?, Object>> stack = STACK.get();
        if (stack != null) {
            for (Map.Entry<?, Object> e : stack) {
                if (key != e.getKey()) continue;
                Preconditions.checkState(e.getValue() != null, "Object for %s is not resolved", key);
                LOG.debug("Looked up key {}", e.getKey());
                return requiredClass.cast(e.getValue());
            }
        }
        return null;
    }

    public static void cleanup() {
        STACK.remove();
        LOG.debug("Removed thread state");
    }
}

