/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.yangtools.util.concurrent.CountingRejectedExecutionHandler;
import org.opendaylight.yangtools.util.concurrent.ThreadFactoryProvider;
import org.opendaylight.yangtools.util.concurrent.TrackingLinkedBlockingQueue;
import org.slf4j.LoggerFactory;

public class CachedThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final long IDLE_TIMEOUT_IN_SEC = 60L;
    private final ExecutorQueue executorQueue;
    private final String threadPrefix;
    private final int maximumQueueSize;
    private final RejectedTaskHandler rejectedTaskHandler;

    public CachedThreadPoolExecutor(int maximumPoolSize, int maximumQueueSize, String threadPrefix, Class<?> loggerIdentity) {
        super(0, maximumPoolSize, 60L, TimeUnit.SECONDS, new ExecutorQueue(maximumQueueSize));
        this.threadPrefix = Objects.requireNonNull(threadPrefix);
        this.maximumQueueSize = maximumQueueSize;
        this.setThreadFactory(ThreadFactoryProvider.builder().namePrefix(threadPrefix).logger(LoggerFactory.getLogger(loggerIdentity)).build().get());
        this.executorQueue = (ExecutorQueue)super.getQueue();
        this.rejectedTaskHandler = new RejectedTaskHandler(this.executorQueue.getBackingQueue(), CountingRejectedExecutionHandler.newAbortPolicy());
        super.setRejectedExecutionHandler(this.rejectedTaskHandler);
    }

    @Deprecated
    public CachedThreadPoolExecutor(int maximumPoolSize, int maximumQueueSize, String threadPrefix) {
        this(maximumPoolSize, maximumQueueSize, threadPrefix, CachedThreadPoolExecutor.class);
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        this.rejectedTaskHandler.setDelegateRejectedExecutionHandler(Objects.requireNonNull(handler));
    }

    @Override
    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedTaskHandler.getDelegateRejectedExecutionHandler();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.executorQueue.getBackingQueue();
    }

    public long getLargestQueueSize() {
        return this.executorQueue.getBackingQueue().getLargestQueueSize();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper;
    }

    @Override
    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this).add("Thread Prefix", this.threadPrefix).add("Current Thread Pool Size", this.getPoolSize()).add("Largest Thread Pool Size", this.getLargestPoolSize()).add("Max Thread Pool Size", this.getMaximumPoolSize()).add("Current Queue Size", this.executorQueue.getBackingQueue().size()).add("Largest Queue Size", this.getLargestQueueSize()).add("Max Queue Size", this.maximumQueueSize).add("Active Thread Count", this.getActiveCount()).add("Completed Task Count", this.getCompletedTaskCount()).add("Total Task Count", this.getTaskCount())).toString();
    }

    private static class RejectedTaskHandler
    implements RejectedExecutionHandler {
        private final LinkedBlockingQueue<Runnable> backingQueue;
        private volatile RejectedExecutionHandler delegateRejectedExecutionHandler;

        RejectedTaskHandler(LinkedBlockingQueue<Runnable> backingQueue, RejectedExecutionHandler delegateRejectedExecutionHandler) {
            this.backingQueue = backingQueue;
            this.delegateRejectedExecutionHandler = delegateRejectedExecutionHandler;
        }

        void setDelegateRejectedExecutionHandler(RejectedExecutionHandler delegateRejectedExecutionHandler) {
            this.delegateRejectedExecutionHandler = delegateRejectedExecutionHandler;
        }

        RejectedExecutionHandler getDelegateRejectedExecutionHandler() {
            return this.delegateRejectedExecutionHandler;
        }

        @Override
        public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Executor has been shutdown.");
            }
            if (!this.backingQueue.offer(task)) {
                this.delegateRejectedExecutionHandler.rejectedExecution(task, executor);
            }
        }
    }

    private static class ExecutorQueue
    extends SynchronousQueue<Runnable> {
        private static final long serialVersionUID = 1L;
        private static final long POLL_WAIT_TIME_IN_MS = 300L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"})
        private final TrackingLinkedBlockingQueue<Runnable> backingQueue;

        ExecutorQueue(int maxBackingQueueSize) {
            this.backingQueue = new TrackingLinkedBlockingQueue(maxBackingQueueSize);
        }

        TrackingLinkedBlockingQueue<Runnable> getBackingQueue() {
            return this.backingQueue;
        }

        @Override
        public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
            long totalWaitTime = unit.toMillis(timeout);
            long waitTime = Math.min(totalWaitTime, 300L);
            Runnable task = null;
            while (task == null) {
                task = (Runnable)this.backingQueue.poll();
                if (task != null) continue;
                task = (Runnable)super.poll(waitTime, TimeUnit.MILLISECONDS);
                if ((totalWaitTime -= 300L) <= 0L) break;
                waitTime = Math.min(totalWaitTime, 300L);
            }
            return task;
        }

        @Override
        public Runnable poll() {
            Runnable task = (Runnable)this.backingQueue.poll();
            return task != null ? task : (Runnable)super.poll();
        }
    }
}

