/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.concurrent;

import java.util.Objects;
import org.slf4j.Logger;

public final class LoggingThreadUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private final Logger logger;

    public static Thread.UncaughtExceptionHandler toLogger(Logger logger) {
        return new LoggingThreadUncaughtExceptionHandler(logger);
    }

    private LoggingThreadUncaughtExceptionHandler(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.logger.error("Thread terminated due to uncaught exception: {}", (Object)thread.getName(), (Object)throwable);
    }
}

