/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util.xml;

import com.google.common.annotations.Beta;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

@Beta
public final class UntrustedXML {
    private static final DocumentBuilderFactory DBF;
    private static final SAXParserFactory SPF;
    private static final XMLInputFactory XIF;

    private UntrustedXML() {
        throw new UnsupportedOperationException();
    }

    public static @NonNull DocumentBuilder newDocumentBuilder() {
        try {
            return DBF.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new UnsupportedOperationException("Failed to instantiate a DocumentBuilder", e);
        }
    }

    public static @NonNull SAXParser newSAXParser() {
        try {
            return SPF.newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new UnsupportedOperationException("Failed to instantiate a SAXParser", e);
        }
    }

    public static @NonNull XMLStreamReader createXMLStreamReader(InputStream stream) throws XMLStreamException {
        return XIF.createXMLStreamReader(stream);
    }

    public static @NonNull XMLStreamReader createXMLStreamReader(InputStream stream, Charset charset) throws XMLStreamException {
        return XIF.createXMLStreamReader(stream, charset.name());
    }

    public static @NonNull XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return XIF.createXMLStreamReader(reader);
    }

    private static <T> T getLimited(@NonNull Supplier<T> supplier) {
        ClassLoader loader = UntrustedXML.class.getClassLoader();
        return loader == null ? supplier.get() : ClassLoaderUtils.getWithClassLoader(loader, supplier);
    }

    static {
        Object f = UntrustedXML.getLimited(DocumentBuilderFactory::newInstance);
        ((DocumentBuilderFactory)f).setCoalescing(true);
        ((DocumentBuilderFactory)f).setExpandEntityReferences(false);
        ((DocumentBuilderFactory)f).setIgnoringElementContentWhitespace(true);
        ((DocumentBuilderFactory)f).setIgnoringComments(true);
        ((DocumentBuilderFactory)f).setNamespaceAware(true);
        ((DocumentBuilderFactory)f).setXIncludeAware(false);
        try {
            ((DocumentBuilderFactory)f).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            ((DocumentBuilderFactory)f).setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            ((DocumentBuilderFactory)f).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ((DocumentBuilderFactory)f).setFeature("http://xml.org/sax/features/external-general-entities", false);
            ((DocumentBuilderFactory)f).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionInInitializerError(e);
        }
        DBF = f;
        f = UntrustedXML.getLimited(SAXParserFactory::newInstance);
        ((SAXParserFactory)f).setNamespaceAware(true);
        ((SAXParserFactory)f).setXIncludeAware(false);
        try {
            ((SAXParserFactory)f).setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            ((SAXParserFactory)f).setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            ((SAXParserFactory)f).setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            ((SAXParserFactory)f).setFeature("http://xml.org/sax/features/external-general-entities", false);
            ((SAXParserFactory)f).setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException e) {
            throw new ExceptionInInitializerError(e);
        }
        SPF = f;
        f = UntrustedXML.getLimited(XMLInputFactory::newInstance);
        ((XMLInputFactory)f).setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        ((XMLInputFactory)f).setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        ((XMLInputFactory)f).setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        ((XMLInputFactory)f).setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        XIF = f;
    }
}

