/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Path;
import org.opendaylight.yangtools.util.HashCodeBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifierBuilderImpl;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public class InstanceIdentifier<T extends DataObject>
implements Path<InstanceIdentifier<? extends DataObject>>,
Immutable,
Serializable {
    private static final Field PATHARGUMENTS_FIELD;
    private static final long serialVersionUID = 2L;
    protected final transient Iterable<PathArgument> pathArguments;
    private final Class<T> targetType;
    private final boolean wildcarded;
    private final int hash;
    @Deprecated
    private List<PathArgument> legacyCache;

    InstanceIdentifier(Class<T> type, Iterable<PathArgument> pathArguments, boolean wildcarded, int hash) {
        this.pathArguments = Preconditions.checkNotNull(pathArguments);
        this.targetType = Preconditions.checkNotNull(type);
        this.wildcarded = wildcarded;
        this.hash = hash;
    }

    public final Class<T> getTargetType() {
        return this.targetType;
    }

    public final Iterable<PathArgument> getPathArguments() {
        return Iterables.unmodifiableIterable(this.pathArguments);
    }

    public final boolean isWildcarded() {
        return this.wildcarded;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceIdentifier other = (InstanceIdentifier)obj;
        if (this.pathArguments == other.pathArguments) {
            return true;
        }
        if (this.hash != other.hash) {
            return false;
        }
        if (this.wildcarded != other.wildcarded) {
            return false;
        }
        if (this.targetType != other.targetType) {
            return false;
        }
        if (this.fastNonEqual(other)) {
            return false;
        }
        return Iterables.elementsEqual(this.pathArguments, other.pathArguments);
    }

    protected boolean fastNonEqual(InstanceIdentifier<?> other) {
        return false;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper(this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("targetType", this.targetType).add("path", Iterables.toString(this.pathArguments));
    }

    public final <I extends DataObject> InstanceIdentifier<I> firstIdentifierOf(Class<I> type) {
        int count = 1;
        for (PathArgument a : this.pathArguments) {
            if (type.equals(a.getType())) {
                InstanceIdentifier<?> ret = InstanceIdentifier.internalCreate(Iterables.limit(this.pathArguments, count));
                return ret;
            }
            ++count;
        }
        return null;
    }

    @Deprecated
    public final <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K firstKeyOf(Class<N> listItem, Class<K> listKey) {
        return this.firstKeyOf(listItem);
    }

    public final <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K firstKeyOf(Class<N> listItem) {
        for (PathArgument i : this.pathArguments) {
            if (!listItem.equals(i.getType())) continue;
            Object ret = ((IdentifiableItem)i).getKey();
            return (K)ret;
        }
        return null;
    }

    @Override
    public final boolean contains(InstanceIdentifier<? extends DataObject> other) {
        Preconditions.checkNotNull(other, "other should not be null");
        Iterator<PathArgument> lit = this.pathArguments.iterator();
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            if (lit.next().equals(oit.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsWildcarded(InstanceIdentifier<?> other) {
        Preconditions.checkNotNull(other, "other should not be null");
        Iterator<PathArgument> lit = this.pathArguments.iterator();
        Iterator<PathArgument> oit = other.pathArguments.iterator();
        while (lit.hasNext()) {
            if (!oit.hasNext()) {
                return false;
            }
            PathArgument la = lit.next();
            PathArgument oa = oit.next();
            if (!la.getType().equals(oa.getType())) {
                return false;
            }
            if (!(la instanceof IdentifiableItem) || !(oa instanceof IdentifiableItem) || la.equals(oa)) continue;
            return false;
        }
        return true;
    }

    private InstanceIdentifier<?> childIdentifier(PathArgument arg) {
        return InstanceIdentifier.trustedCreate(arg, Iterables.concat(this.pathArguments, Collections.singleton(arg)), HashCodeBuilder.nextHashCode(this.hash, arg), this.isWildcarded());
    }

    public final <N extends ChildOf<? super T>> InstanceIdentifier<N> child(Class<N> container) {
        Item<N> arg = new Item<N>(container);
        return this.childIdentifier(arg);
    }

    public final <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> KeyedInstanceIdentifier<N, K> child(Class<N> listItem, K listKey) {
        IdentifiableItem<N, K> arg = new IdentifiableItem<N, K>(listItem, listKey);
        return (KeyedInstanceIdentifier)this.childIdentifier(arg);
    }

    public final <N extends DataObject & Augmentation<? super T>> InstanceIdentifier<N> augmentation(Class<N> container) {
        Item<N> arg = new Item<N>(container);
        return this.childIdentifier(arg);
    }

    @Deprecated
    public final List<PathArgument> getPath() {
        if (this.legacyCache == null) {
            this.legacyCache = ImmutableList.copyOf(this.pathArguments);
        }
        return this.legacyCache;
    }

    public InstanceIdentifierBuilder<T> builder() {
        return new InstanceIdentifierBuilderImpl(new Item<T>(this.targetType), this.pathArguments, this.hash, this.isWildcarded());
    }

    @Deprecated
    public static <T extends DataObject> InstanceIdentifierBuilder<T> builder(InstanceIdentifier<T> base) {
        return base.builder();
    }

    public static <T extends ChildOf<? extends DataRoot>> InstanceIdentifierBuilder<T> builder(Class<T> container) {
        return new InstanceIdentifierBuilderImpl().addNode(container);
    }

    public static <N extends Identifiable<K> & ChildOf<? extends DataRoot>, K extends Identifier<N>> InstanceIdentifierBuilder<N> builder(Class<N> listItem, K listKey) {
        return new InstanceIdentifierBuilderImpl().addNode(listItem, listKey);
    }

    private static InstanceIdentifier<?> internalCreate(Iterable<PathArgument> pathArguments) {
        Iterator<PathArgument> it = Preconditions.checkNotNull(pathArguments, "pathArguments may not be null").iterator();
        HashCodeBuilder<PathArgument> hashBuilder = new HashCodeBuilder<PathArgument>();
        boolean wildcard = false;
        PathArgument arg = null;
        while (it.hasNext()) {
            arg = it.next();
            Preconditions.checkArgument(arg != null, "pathArguments may not contain null elements");
            hashBuilder.addArgument(arg);
            if (!Identifiable.class.isAssignableFrom(arg.getType()) || arg instanceof IdentifiableItem) continue;
            wildcard = true;
        }
        Preconditions.checkArgument(arg != null, "pathArguments may not be empty");
        return InstanceIdentifier.trustedCreate(arg, pathArguments, hashBuilder.build(), wildcard);
    }

    public static InstanceIdentifier<?> create(Iterable<? extends PathArgument> pathArguments) {
        if (pathArguments instanceof ImmutableCollection) {
            Iterable<PathArgument> immutableArguments = pathArguments;
            return InstanceIdentifier.internalCreate(immutableArguments);
        }
        return InstanceIdentifier.internalCreate(ImmutableList.copyOf(pathArguments));
    }

    public static <T extends DataObject> InstanceIdentifier<T> create(Class<T> type) {
        return InstanceIdentifier.create(Collections.singletonList(new Item<T>(type)));
    }

    public static <N extends Identifiable<K> & DataObject, K extends Identifier<N>> K keyOf(InstanceIdentifier<N> id) {
        Preconditions.checkNotNull(id);
        Preconditions.checkArgument(id instanceof KeyedInstanceIdentifier, "%s does not have a key", id);
        Object ret = ((KeyedInstanceIdentifier)id).getKey();
        return ret;
    }

    static InstanceIdentifier<?> trustedCreate(PathArgument arg, Iterable<PathArgument> pathArguments, int hash, boolean wildcarded) {
        if (Identifiable.class.isAssignableFrom(arg.getType()) && !wildcarded) {
            Identifier key = null;
            if (arg instanceof IdentifiableItem) {
                key = ((IdentifiableItem)arg).key;
            } else {
                wildcarded = true;
            }
            return new KeyedInstanceIdentifier<DataObject, Identifier>(arg.getType(), pathArguments, wildcarded, hash, key);
        }
        return new InstanceIdentifier<DataObject>(arg.getType(), pathArguments, wildcarded, hash);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(Iterables.size(this.pathArguments));
        for (PathArgument o : this.pathArguments) {
            out.writeObject(o);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = in.readInt();
        ArrayList<PathArgument> args = new ArrayList<PathArgument>(size);
        for (int i = 0; i < size; ++i) {
            args.add((PathArgument)in.readObject());
        }
        try {
            PATHARGUMENTS_FIELD.set(this, ImmutableList.copyOf(args));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    static {
        Field f;
        try {
            f = InstanceIdentifier.class.getDeclaredField("pathArguments");
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ExceptionInInitializerError(e);
        }
        f.setAccessible(true);
        PATHARGUMENTS_FIELD = f;
    }

    public static interface InstanceIdentifierBuilder<T extends DataObject>
    extends Builder<InstanceIdentifier<T>> {
        public <N extends ChildOf<? super T>> InstanceIdentifierBuilder<N> child(Class<N> var1);

        public <N extends Identifiable<K> & ChildOf<? super T>, K extends Identifier<N>> InstanceIdentifierBuilder<N> child(Class<N> var1, K var2);

        public <N extends DataObject & Augmentation<? super T>> InstanceIdentifierBuilder<N> augmentation(Class<N> var1);

        @Override
        public InstanceIdentifier<T> build();

        @Deprecated
        public InstanceIdentifier<T> toInstance();
    }

    public static final class IdentifiableItem<I extends Identifiable<T> & DataObject, T extends Identifier<I>>
    extends AbstractPathArgument<I> {
        private static final long serialVersionUID = 1L;
        private final T key;

        public IdentifiableItem(Class<I> type, T key) {
            super(type);
            this.key = (Identifier)Preconditions.checkNotNull(key, "Key may not be null.");
        }

        public T getKey() {
            return this.key;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && this.key.equals(((IdentifiableItem)obj).getKey());
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 31 + this.key.hashCode();
        }

        public String toString() {
            return this.getType().getName() + "[key=" + this.key + "]";
        }
    }

    public static final class Item<T extends DataObject>
    extends AbstractPathArgument<T> {
        private static final long serialVersionUID = 1L;

        public Item(Class<T> type) {
            super(type);
        }

        public String toString() {
            return this.getType().getName();
        }
    }

    private static abstract class AbstractPathArgument<T extends DataObject>
    implements PathArgument,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Class<T> type;

        protected AbstractPathArgument(Class<T> type) {
            this.type = Preconditions.checkNotNull(type, "Type may not be null.");
        }

        public final Class<T> getType() {
            return this.type;
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AbstractPathArgument other = (AbstractPathArgument)obj;
            return this.type.equals(other.type);
        }

        @Override
        public int compareTo(PathArgument arg) {
            return this.type.getCanonicalName().compareTo(arg.getType().getCanonicalName());
        }
    }

    public static interface PathArgument
    extends Comparable<PathArgument> {
        public Class<? extends DataObject> getType();
    }
}

