/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Optional;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.binding.util.RpcMethodInvokerWithInput;
import org.opendaylight.yangtools.yang.binding.util.RpcMethodInvokerWithoutInput;
import org.opendaylight.yangtools.yang.common.RpcResult;

abstract class RpcMethodInvoker {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();

    RpcMethodInvoker() {
    }

    protected abstract Future<RpcResult<?>> invokeOn(RpcService var1, DataObject var2);

    protected static RpcMethodInvoker from(Method method) {
        Optional<Class<? extends DataContainer>> input = BindingReflections.resolveRpcInputClass(method);
        try {
            MethodHandle methodHandle = LOOKUP.unreflect(method);
            if (input.isPresent()) {
                return new RpcMethodInvokerWithInput(methodHandle);
            }
            return new RpcMethodInvokerWithoutInput(methodHandle);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Lookup on public method failed.", e);
        }
    }
}

