/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding.util;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.concurrent.Future;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.RpcMethodInvoker;
import org.opendaylight.yangtools.yang.common.RpcResult;

class RpcMethodInvokerWithoutInput
extends RpcMethodInvoker {
    private static final MethodType INVOCATION_SIGNATURE = MethodType.methodType(Future.class, RpcService.class);
    private final MethodHandle handle;

    RpcMethodInvokerWithoutInput(MethodHandle methodHandle) {
        this.handle = methodHandle.asType(INVOCATION_SIGNATURE);
    }

    @Override
    public Future<RpcResult<?>> invokeOn(RpcService impl, DataObject input) {
        try {
            return this.handle.invokeExact(impl);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked(e);
            throw new RuntimeException(e);
        }
    }
}

