/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
abstract class AbstractCanonicalValueImplementationValidator
extends ClassValue<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCanonicalValueImplementationValidator.class);

    AbstractCanonicalValueImplementationValidator() {
    }

    @Override
    protected final Boolean computeValue(@Nullable Class<?> type) {
        Preconditions.checkArgument(CanonicalValue.class.isAssignableFrom(type), "%s is not a DerivedString", type);
        int modifiers = type.getModifiers();
        Preconditions.checkArgument(Modifier.isPublic(modifiers), "%s must be public", type);
        Preconditions.checkArgument(!Modifier.isFinal(modifiers), "%s must not be final", type);
        Preconditions.checkArgument(Arrays.stream(type.getDeclaredConstructors()).mapToInt(Constructor::getModifiers).anyMatch(mod -> Modifier.isProtected(mod) || Modifier.isPublic(mod)), "%s must declare at least one protected or public constructor", type);
        try {
            int validator;
            try {
                validator = type.getMethod("validator", new Class[0]).getModifiers();
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(type + " must have a non-abstract non-final validator() method", e);
            }
            Preconditions.checkArgument(!Modifier.isFinal(validator), "%s must not have final validator()", type);
            AbstractCanonicalValueImplementationValidator.checkFinalMethod(type, "toCanonicalString");
            AbstractCanonicalValueImplementationValidator.checkFinalMethod(type, "support");
            AbstractCanonicalValueImplementationValidator.checkFinalMethod(type, "hashCode");
            AbstractCanonicalValueImplementationValidator.checkFinalMethod(type, "equals", Object.class);
        }
        catch (SecurityException e) {
            LOG.warn("Cannot completely validate {}", (Object)type, (Object)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    abstract void checkCompareTo(Class<?> var1);

    static void checkFinalMethod(Class<?> type, String name) {
        try {
            AbstractCanonicalValueImplementationValidator.checkFinalMethod(type.getMethod(name, new Class[0]).getModifiers(), type, name, "");
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " must have a final " + name + "() method", e);
        }
    }

    static void checkFinalMethod(Class<?> type, String name, Class<?> arg) {
        String argName = arg.getSimpleName();
        try {
            AbstractCanonicalValueImplementationValidator.checkFinalMethod(type.getMethod(name, arg).getModifiers(), type, name, argName);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(type + " must have a final " + name + "(" + argName + ") method", e);
        }
    }

    private static void checkFinalMethod(int modifiers, Class<?> type, String name, String args) {
        Preconditions.checkArgument(Modifier.isFinal(modifiers), "%s must have a final %s(%s) method", type, (Object)name, (Object)args);
    }
}

