/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BaseStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.BitStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.EnumStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FractionDigitsStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LengthStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PathStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RangeStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RequireInstanceStatement;

public interface TypeStatement
extends DeclaredStatement<String> {
    @Nonnull
    default public String getName() {
        return (String)this.argument();
    }

    public static interface BinarySpecification
    extends TypeStatement {
        @Nonnull
        default public Collection<? extends LengthStatement> getLength() {
            return this.declaredSubstatements(LengthStatement.class);
        }
    }

    public static interface UnionSpecification
    extends TypeStatement {
        @Nonnull
        default public Collection<? extends TypeStatement> getTypes() {
            return this.declaredSubstatements(TypeStatement.class);
        }
    }

    public static interface BitsSpecification
    extends TypeStatement {
        @Nonnull
        default public Collection<? extends BitStatement> getBits() {
            return this.declaredSubstatements(BitStatement.class);
        }
    }

    public static interface IdentityRefSpecification
    extends TypeStatement {
        @Nonnull
        default public Collection<? extends BaseStatement> getBases() {
            return this.declaredSubstatements(BaseStatement.class);
        }
    }

    public static interface InstanceIdentifierSpecification
    extends TypeStatement {
        @Nullable
        default public RequireInstanceStatement getRequireInstance() {
            Optional<RequireInstanceStatement> opt = this.findFirstDeclaredSubstatement(RequireInstanceStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }
    }

    public static interface LeafrefSpecification
    extends TypeStatement {
        @Nonnull
        default public PathStatement getPath() {
            return this.findFirstDeclaredSubstatement(PathStatement.class).get();
        }

        @Nullable
        default public RequireInstanceStatement getRequireInstance() {
            Optional<RequireInstanceStatement> opt = this.findFirstDeclaredSubstatement(RequireInstanceStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }
    }

    public static interface EnumSpecification
    extends TypeStatement {
        @Nonnull
        default public Collection<? extends EnumStatement> getEnums() {
            return this.declaredSubstatements(EnumStatement.class);
        }
    }

    public static interface StringRestrictions
    extends TypeStatement {
        @Nullable
        default public LengthStatement getLength() {
            Optional<LengthStatement> opt = this.findFirstDeclaredSubstatement(LengthStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }

        @Nonnull
        default public Collection<? extends PatternStatement> getPatterns() {
            return this.declaredSubstatements(PatternStatement.class);
        }
    }

    public static interface Decimal64Specification
    extends TypeStatement {
        @Nonnull
        default public FractionDigitsStatement getFractionDigits() {
            return this.findFirstDeclaredSubstatement(FractionDigitsStatement.class).get();
        }

        @Nullable
        default public RangeStatement getRange() {
            Optional<RangeStatement> opt = this.findFirstDeclaredSubstatement(RangeStatement.class);
            return opt.isPresent() ? opt.get() : null;
        }
    }

    public static interface NumericalRestrictions
    extends TypeStatement {
        @Nonnull
        default public RangeStatement getRange() {
            return this.findFirstDeclaredSubstatement(RangeStatement.class).get();
        }
    }
}

