/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;

@Beta
public final class ResourceYangTextSchemaSource
extends YangTextSchemaSource
implements Delegator<URL> {
    private final URL url;

    ResourceYangTextSchemaSource(SourceIdentifier identifier, URL url) {
        super(identifier);
        this.url = Objects.requireNonNull(url);
    }

    @Override
    public URL getDelegate() {
        return this.url;
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("url", this.url);
    }

    @Override
    public InputStream openStream() throws IOException {
        return this.url.openStream();
    }

    @Override
    public Optional<String> getSymbolicName() {
        return Optional.of(this.url.toString());
    }
}

