/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.repo.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceFilter;
import org.opendaylight.yangtools.yang.model.repo.api.StatementParserMode;

@Beta
public final class SchemaContextFactoryConfiguration
implements Immutable {
    private static final SchemaContextFactoryConfiguration DEFAULT_CONFIGURATION = new Builder().build();
    private final SchemaSourceFilter filter;
    private final StatementParserMode statementParserMode;
    private final Set<QName> supportedFeatures;
    private final SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules;

    private SchemaContextFactoryConfiguration(SchemaSourceFilter filter, StatementParserMode statementParserMode, Set<QName> supportedFeatures, SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
        this.filter = Objects.requireNonNull(filter);
        this.statementParserMode = Objects.requireNonNull(statementParserMode);
        this.supportedFeatures = supportedFeatures;
        this.modulesDeviatedByModules = modulesDeviatedByModules;
    }

    public SchemaSourceFilter getSchemaSourceFilter() {
        return this.filter;
    }

    public StatementParserMode getStatementParserMode() {
        return this.statementParserMode;
    }

    public Optional<Set<QName>> getSupportedFeatures() {
        return Optional.ofNullable(this.supportedFeatures);
    }

    public Optional<SetMultimap<QNameModule, QNameModule>> getModulesDeviatedByModules() {
        return Optional.ofNullable(this.modulesDeviatedByModules);
    }

    public static SchemaContextFactoryConfiguration getDefault() {
        return DEFAULT_CONFIGURATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filter, this.statementParserMode, this.supportedFeatures, this.modulesDeviatedByModules});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SchemaContextFactoryConfiguration)) {
            return false;
        }
        SchemaContextFactoryConfiguration other = (SchemaContextFactoryConfiguration)obj;
        return this.filter.equals(other.filter) && this.statementParserMode.equals((Object)other.statementParserMode) && Objects.equals(this.supportedFeatures, other.supportedFeatures) && Objects.equals(this.modulesDeviatedByModules, other.modulesDeviatedByModules);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).omitNullValues().add("schemaSourceFilter", this.filter).add("statementParserMode", (Object)this.statementParserMode).add("supportedFeatures", this.supportedFeatures).add("modulesDeviatedByModules", this.modulesDeviatedByModules).toString();
    }

    public static class Builder
    implements org.opendaylight.yangtools.concepts.Builder<SchemaContextFactoryConfiguration> {
        private SchemaSourceFilter filter = SchemaSourceFilter.ALWAYS_ACCEPT;
        private StatementParserMode statementParserMode = StatementParserMode.DEFAULT_MODE;
        private SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules;
        private Set<QName> supportedFeatures;

        public Builder setFilter(@Nonnull SchemaSourceFilter filter) {
            this.filter = Objects.requireNonNull(filter);
            return this;
        }

        public Builder setStatementParserMode(@Nonnull StatementParserMode statementParserMode) {
            this.statementParserMode = Objects.requireNonNull(statementParserMode);
            return this;
        }

        public Builder setSupportedFeatures(Set<QName> supportedFeatures) {
            this.supportedFeatures = supportedFeatures != null ? ImmutableSet.copyOf(supportedFeatures) : null;
            return this;
        }

        public Builder setModulesDeviatedByModules(SetMultimap<QNameModule, QNameModule> modulesDeviatedByModules) {
            this.modulesDeviatedByModules = modulesDeviatedByModules != null ? ImmutableSetMultimap.copyOf(modulesDeviatedByModules) : null;
            return this;
        }

        @Override
        public SchemaContextFactoryConfiguration build() {
            return new SchemaContextFactoryConfiguration(this.filter, this.statementParserMode, this.supportedFeatures, this.modulesDeviatedByModules);
        }
    }
}

