/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum PccSyncState implements Enumeration
{
    InitialResync(0, "initial-resync"),
    IncrementalSync(1, "incremental-sync"),
    TriggeredInitialSync(2, "triggered-initial-sync"),
    PcepTriggeredResync(3, "pcep-triggered-resync"),
    Synchronized(4, "synchronized");

    private static final Map<String, PccSyncState> NAME_MAP;
    private static final Map<Integer, PccSyncState> VALUE_MAP;
    private final String name;
    private final int value;

    private PccSyncState(int value, String name) {
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIntValue() {
        return this.value;
    }

    public static Optional<PccSyncState> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static PccSyncState forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder nb = ImmutableMap.builder();
        ImmutableMap.Builder vb = ImmutableMap.builder();
        for (PccSyncState enumItem : PccSyncState.values()) {
            vb.put((Object)enumItem.value, (Object)enumItem);
            nb.put((Object)enumItem.name, (Object)enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

