/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.PccSyncState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.path.computation.client.ReportedLspKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.path.computation.client.StatefulTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathComputationClientBuilder
implements Builder<PathComputationClient> {
    private IpAddressNoZone _ipAddress;
    private Map<ReportedLspKey, ReportedLsp> _reportedLsp;
    private PccSyncState _stateSync;
    private StatefulTlv _statefulTlv;
    Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();

    public PathComputationClientBuilder() {
    }

    public PathComputationClientBuilder(PathComputationClient base) {
        Map aug;
        if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(aug);
        }
        this._ipAddress = base.getIpAddress();
        this._reportedLsp = base.getReportedLsp();
        this._stateSync = base.getStateSync();
        this._statefulTlv = base.getStatefulTlv();
    }

    public IpAddressNoZone getIpAddress() {
        return this._ipAddress;
    }

    public Map<ReportedLspKey, ReportedLsp> getReportedLsp() {
        return this._reportedLsp;
    }

    public PccSyncState getStateSync() {
        return this._stateSync;
    }

    public StatefulTlv getStatefulTlv() {
        return this._statefulTlv;
    }

    public <E$$ extends Augmentation<PathComputationClient>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PathComputationClientBuilder setIpAddress(IpAddressNoZone value) {
        this._ipAddress = value;
        return this;
    }

    public PathComputationClientBuilder setReportedLsp(Map<ReportedLspKey, ReportedLsp> values) {
        this._reportedLsp = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public PathComputationClientBuilder setReportedLsp(List<ReportedLsp> values) {
        return this.setReportedLsp(CodeHelpers.compatMap(values));
    }

    public PathComputationClientBuilder setStateSync(PccSyncState value) {
        this._stateSync = value;
        return this;
    }

    public PathComputationClientBuilder setStatefulTlv(StatefulTlv value) {
        this._statefulTlv = value;
        return this;
    }

    public PathComputationClientBuilder addAugmentation(Augmentation<PathComputationClient> augmentation) {
        return this.doAddAugmentation(augmentation.implementedInterface(), augmentation);
    }

    @Deprecated(forRemoval=true)
    public PathComputationClientBuilder addAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType, Augmentation<PathComputationClient> augmentationValue) {
        return augmentationValue == null ? this.removeAugmentation(augmentationType) : this.doAddAugmentation(augmentationType, augmentationValue);
    }

    public PathComputationClientBuilder removeAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    private PathComputationClientBuilder doAddAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType, Augmentation<PathComputationClient> augmentationValue) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathComputationClient build() {
        return new PathComputationClientImpl(this);
    }

    private static final class PathComputationClientImpl
    extends AbstractAugmentable<PathComputationClient>
    implements PathComputationClient {
        private final IpAddressNoZone _ipAddress;
        private final Map<ReportedLspKey, ReportedLsp> _reportedLsp;
        private final PccSyncState _stateSync;
        private final StatefulTlv _statefulTlv;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PathComputationClientImpl(PathComputationClientBuilder base) {
            super(base.augmentation);
            this._ipAddress = base.getIpAddress();
            this._reportedLsp = CodeHelpers.emptyToNull(base.getReportedLsp());
            this._stateSync = base.getStateSync();
            this._statefulTlv = base.getStatefulTlv();
        }

        @Override
        public IpAddressNoZone getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public Map<ReportedLspKey, ReportedLsp> getReportedLsp() {
            return this._reportedLsp;
        }

        @Override
        public PccSyncState getStateSync() {
            return this._stateSync;
        }

        @Override
        public StatefulTlv getStatefulTlv() {
            return this._statefulTlv;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipAddress);
            result = 31 * result + Objects.hashCode(this._reportedLsp);
            result = 31 * result + Objects.hashCode((Object)this._stateSync);
            result = 31 * result + Objects.hashCode(this._statefulTlv);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentations());
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathComputationClient.class.equals((Object)((DataObject)obj).implementedInterface())) {
                return false;
            }
            PathComputationClient other = (PathComputationClient)obj;
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (!Objects.equals(this._reportedLsp, other.getReportedLsp())) {
                return false;
            }
            if (!Objects.equals((Object)this._stateSync, (Object)other.getStateSync())) {
                return false;
            }
            if (!Objects.equals(this._statefulTlv, other.getStatefulTlv())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathComputationClientImpl otherImpl = (PathComputationClientImpl)obj;
                if (!Objects.equals(this.augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                for (Map.Entry e : this.augmentations().entrySet()) {
                    if (((Augmentation)e.getValue()).equals(other.augmentation((Class)e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"PathComputationClient");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_ipAddress", (Object)this._ipAddress);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_reportedLsp", this._reportedLsp);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_stateSync", (Object)((Object)this._stateSync));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_statefulTlv", (Object)this._statefulTlv);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", (Object)this.augmentations().values());
            return helper.toString();
        }
    }
}

