/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.PccSyncState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.path.computation.client.ReportedLspKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev200120.pcep.client.attributes.path.computation.client.StatefulTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class PathComputationClientBuilder
implements Builder<PathComputationClient> {
    private IpAddressNoZone _ipAddress;
    private Map<ReportedLspKey, ReportedLsp> _reportedLsp;
    private PccSyncState _stateSync;
    private StatefulTlv _statefulTlv;
    Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();

    public PathComputationClientBuilder() {
    }

    public PathComputationClientBuilder(PathComputationClient base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(aug);
        }
        this._ipAddress = base.getIpAddress();
        this._reportedLsp = base.getReportedLsp();
        this._stateSync = base.getStateSync();
        this._statefulTlv = base.getStatefulTlv();
    }

    public IpAddressNoZone getIpAddress() {
        return this._ipAddress;
    }

    public Map<ReportedLspKey, ReportedLsp> getReportedLsp() {
        return this._reportedLsp;
    }

    public PccSyncState getStateSync() {
        return this._stateSync;
    }

    public StatefulTlv getStatefulTlv() {
        return this._statefulTlv;
    }

    public <E$$ extends Augmentation<PathComputationClient>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PathComputationClientBuilder setIpAddress(IpAddressNoZone value) {
        this._ipAddress = value;
        return this;
    }

    public PathComputationClientBuilder setReportedLsp(Map<ReportedLspKey, ReportedLsp> values) {
        this._reportedLsp = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public PathComputationClientBuilder setReportedLsp(List<ReportedLsp> values) {
        return this.setReportedLsp(CodeHelpers.compatMap(values));
    }

    public PathComputationClientBuilder setStateSync(PccSyncState value) {
        this._stateSync = value;
        return this;
    }

    public PathComputationClientBuilder setStatefulTlv(StatefulTlv value) {
        this._statefulTlv = value;
        return this;
    }

    public PathComputationClientBuilder addAugmentation(Augmentation<PathComputationClient> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PathComputationClientBuilder removeAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public PathComputationClient build() {
        return new PathComputationClientImpl(this);
    }

    private static final class PathComputationClientImpl
    extends AbstractAugmentable<PathComputationClient>
    implements PathComputationClient {
        private final IpAddressNoZone _ipAddress;
        private final Map<ReportedLspKey, ReportedLsp> _reportedLsp;
        private final PccSyncState _stateSync;
        private final StatefulTlv _statefulTlv;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PathComputationClientImpl(PathComputationClientBuilder base) {
            super(base.augmentation);
            this._ipAddress = base.getIpAddress();
            this._reportedLsp = CodeHelpers.emptyToNull(base.getReportedLsp());
            this._stateSync = base.getStateSync();
            this._statefulTlv = base.getStatefulTlv();
        }

        @Override
        public IpAddressNoZone getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public Map<ReportedLspKey, ReportedLsp> getReportedLsp() {
            return this._reportedLsp;
        }

        @Override
        public PccSyncState getStateSync() {
            return this._stateSync;
        }

        @Override
        public StatefulTlv getStatefulTlv() {
            return this._statefulTlv;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = PathComputationClient.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return PathComputationClient.bindingEquals(this, obj);
        }

        public String toString() {
            return PathComputationClient.bindingToString(this);
        }
    }
}

