/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.Topology;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class TopologyBuilder {
    private Map<NodeKey, Node> _node;
    private TopologyId _topologyId;
    private TopologyKey key;
    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Map.of();

    public TopologyBuilder() {
    }

    public TopologyBuilder(Topology base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>(aug);
        }
        this.key = base.key();
        this._topologyId = base.getTopologyId();
        this._node = base.getNode();
    }

    public TopologyKey key() {
        return this.key;
    }

    public Map<NodeKey, Node> getNode() {
        return this._node;
    }

    public TopologyId getTopologyId() {
        return this._topologyId;
    }

    public <E$$ extends Augmentation<Topology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public TopologyBuilder withKey(TopologyKey key) {
        this.key = key;
        return this;
    }

    public TopologyBuilder setNode(Map<NodeKey, Node> values) {
        this._node = values;
        return this;
    }

    public TopologyBuilder setTopologyId(TopologyId value) {
        this._topologyId = value;
        return this;
    }

    public TopologyBuilder addAugmentation(Augmentation<Topology> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Topology>>, Augmentation<Topology>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
    extends AbstractAugmentable<Topology>
    implements Topology {
        private final Map<NodeKey, Node> _node;
        private final TopologyId _topologyId;
        private final TopologyKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        TopologyImpl(TopologyBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new TopologyKey(base.getTopologyId());
            this._topologyId = this.key.getTopologyId();
            this._node = CodeHelpers.emptyToNull(base.getNode());
        }

        @Override
        public TopologyKey key() {
            return this.key;
        }

        @Override
        public Map<NodeKey, Node> getNode() {
            return this._node;
        }

        @Override
        public TopologyId getTopologyId() {
            return this._topologyId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Topology.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Topology.bindingEquals(this, obj);
        }

        public String toString() {
            return Topology.bindingToString(this);
        }
    }
}

