package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.Class;
import java.lang.FunctionalInterface;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Fetch PCEP session statistics for given PCEP topology and node. If topology 
 * and/or node details are absent, statistics for all nodes under the context are 
 * returned.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-topology-stats-rpc</b>
 * <pre>
 * rpc get-stats {
 *   input input {
 *     list topology {
 *       key topology-id;
 *       leaf topology-id {
 *         type nt:topology-id;
 *       }
 *       list node {
 *         key node-id;
 *         leaf node-id {
 *           type nt:node-id;
 *         }
 *       }
 *     }
 *   }
 *   output output {
 *     list topology {
 *       key topology-id;
 *       leaf topology-id {
 *         type nt:topology-id;
 *       }
 *       list node {
 *         key node-id;
 *         leaf node-id {
 *           type nt:node-id;
 *         }
 *         uses pss:pcep-session-state-grouping;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@FunctionalInterface
@Generated("mdsal-binding-generator")
public interface GetStats
    extends
    Rpc<GetStatsInput, GetStatsOutput>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("get-stats");

    @Override
    ListenableFuture<RpcResult<GetStatsOutput>> invoke(GetStatsInput input);
    
    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.GetStats> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.GetStats.class;
    }

}

