package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.GetStatsInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>pcep-topology-stats-rpc</b>
 * <pre>
 * list topology {
 *   key topology-id;
 *   leaf topology-id {
 *     type nt:topology-id;
 *   }
 *   list node {
 *     key node-id;
 *     leaf node-id {
 *       type nt:node-id;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link TopologyBuilder}.
 * @see TopologyBuilder
 * @see TopologyKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Topology
    extends
    ChildOf<GetStatsInput>,
    Augmentable<Topology>,
    KeyAware<TopologyKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("topology");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.Topology> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.Topology.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.@NonNull Topology obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getNode());
        result = prime * result + Objects.hashCode(obj.getTopologyId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.@NonNull Topology thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.Topology.class, obj);
        return other != null
            && Objects.equals(thisObj.getTopologyId(), other.getTopologyId())
            && Objects.equals(thisObj.getNode(), other.getNode())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.@NonNull Topology obj) {
        final var helper = MoreObjects.toStringHelper("Topology");
        CodeHelpers.appendValue(helper, "node", obj.getNode());
        CodeHelpers.appendValue(helper, "topologyId", obj.getTopologyId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    TopologyKey key();
    
    /**
     * Return topologyId, or {@code null} if it is not present.
     *
     * @return {@code TopologyId} topologyId, or {@code null} if it is not present.
     *
     */
    TopologyId getTopologyId();
    
    /**
     * Return topologyId, guaranteed to be non-null.
     *
     * @return {@code TopologyId} topologyId, guaranteed to be non-null.
     * @throws NoSuchElementException if topologyId is not present
     *
     */
    default @NonNull TopologyId requireTopologyId() {
        return CodeHelpers.require(getTopologyId(), "topologyid");
    }
    
    /**
     * Return node, or {@code null} if it is not present.
     *
     * @return {@code Map<NodeKey, Node>} node, or {@code null} if it is not present.
     *
     */
    @Nullable Map<NodeKey, Node> getNode();
    
    /**
     * Return node, or an empty list if it is not present.
     *
     * @return {@code Map<NodeKey, Node>} node, or an empty list if it is not present.
     *
     */
    default @NonNull Map<NodeKey, Node> nonnullNode() {
        return CodeHelpers.nonnull(getNode());
    }

}

