package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.programming.rev181109;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the PCEP extensions to base topology model. It exposes the 
 * LSPs for which a particular node is the head end. This module exposes three 
 * programming instructions,add-lsp, remove-lsp and update-lsp, which map to 
 * actively-stateful PCEP operations using PCInitiate and PCUpd messages to 
 * initiate, destroy and udpate LSP configuration. The lifecycle of these 
 * instructions follows RFC8281 and RFC 8231, completing execution once the 
 * head-end router has acknowledged operation success. Should the router become 
 * disconnected, the instruction resolve to Cancelled if the message has not been 
 * sent into the TCP socket, or Failed it they have. Copyright (c)2013 Cisco 
 * Systems, Inc. All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 which 
 * accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep-programming</b>
 * <pre>
 * module network-topology-pcep-programming {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:topology:pcep:programming;
 *   prefix pnp;
 *   import network-topology-programming {
 *     prefix ntp;
 *     revision-date 2013-11-02;
 *   }
 *   import network-topology-pcep {
 *     prefix pcep;
 *     revision-date 2022-07-30;
 *   }
 *   revision 2018-11-09 {
 *   }
 *   revision 2017-10-25 {
 *   }
 *   revision 2013-11-06 {
 *   }
 *   rpc submit-add-lsp {
 *     input input {
 *       uses ntp:topology-instruction-input;
 *       uses pcep:add-lsp-args;
 *     }
 *     output output {
 *       uses ntp:topology-instruction-output;
 *     }
 *   }
 *   rpc submit-remove-lsp {
 *     input input {
 *       uses ntp:topology-instruction-input;
 *       uses pcep:remove-lsp-args;
 *     }
 *     output output {
 *       uses ntp:topology-instruction-output;
 *     }
 *   }
 *   rpc submit-update-lsp {
 *     input input {
 *       uses ntp:topology-instruction-input;
 *       uses pcep:update-lsp-args;
 *     }
 *     output output {
 *       uses ntp:topology-instruction-output;
 *     }
 *   }
 *   rpc submit-ensure-lsp-operational {
 *     input input {
 *       uses ntp:topology-instruction-input;
 *       uses pcep:ensure-lsp-operational-args;
 *     }
 *     output output {
 *       uses ntp:topology-instruction-output;
 *     }
 *   }
 *   rpc submit-trigger-sync {
 *     input input {
 *       uses ntp:topology-instruction-input;
 *       uses pcep:trigger-sync-args;
 *     }
 *     output output {
 *       uses ntp:topology-instruction-output;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface NetworkTopologyPcepProgrammingData
    extends
    DataRoot
{





}

