package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains the PCEP extensions to base topology model. It exposes the 
 * LSPs for which a particular node is the head end. This module exposes three 
 * programming instructions,add-lsp, remove-lsp and update-lsp, which map to 
 * actively-stateful PCEP operations using PCInitiate and PCUpd messages to 
 * initiate, destroy and udpate LSP configuration. The lifecycle of these 
 * instructions follows RFC8281 and RFC8231, completing execution once the 
 * router has acknowledged operation success. Should the router become 
 * disconnected, the instruction resolve to Cancelled if the message has not been 
 * sent into the TCP socket, or Failed it they have. Copyright (c)2013 Cisco 
 * Systems, Inc. All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 which 
 * accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * module network-topology-pcep {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:topology:pcep;
 *   prefix pn;
 *   import ietf-inet-types {
 *     prefix inet;
 *     revision-date 2013-07-15;
 *   }
 *   import network-topology {
 *     prefix nt;
 *     revision-date 2013-10-21;
 *   }
 *   import odl-network-topology {
 *     prefix ont;
 *     revision-date 2014-01-13;
 *   }
 *   import pcep-types {
 *     prefix pcep;
 *     revision-date 2018-11-09;
 *   }
 *   import rsvp {
 *     prefix rsvp;
 *     revision-date 2015-08-20;
 *   }
 *   import pcep-config {
 *     prefix pdc;
 *   }
 *   revision 2022-07-30 {
 *   }
 *   revision 2020-01-20 {
 *   }
 *   revision 2018-11-09 {
 *   }
 *   revision 2017-10-25 {
 *   }
 *   revision 2013-10-24 {
 *   }
 *   typedef pcc-sync-state {
 *     type enumeration {
 *       enum initial-resync {
 *       }
 *       enum incremental-sync {
 *       }
 *       enum triggered-initial-sync {
 *       }
 *       enum pcep-triggered-resync {
 *       }
 *       enum synchronized {
 *       }
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:topology-types {
 *     container topology-pcep {
 *       presence "indicates a PCEP-aware topology";
 *       leaf ted-name {
 *         type leafref {
 *           path /nt:network-topology/nt:topology/nt:topology-id;
 *         }
 *       }
 *       uses pdc:pcep-config;
 *     }
 *   }
 *   grouping pcep-client-attributes {
 *     container path-computation-client {
 *       config false;
 *       leaf ip-address {
 *         type inet:ip-address-no-zone;
 *       }
 *       container stateful-tlv;
 *       leaf state-sync {
 *         type pcc-sync-state;
 *         when ../stateful-tlv;
 *       }
 *       list reported-lsp {
 *         leaf name {
 *           type string;
 *         }
 *         key name;
 *         list path {
 *           leaf lsp-id {
 *             type rsvp:lsp-id;
 *           }
 *           key lsp-id;
 *           uses pcep:path-definition;
 *         }
 *         uses lsp-metadata;
 *       }
 *     }
 *   }
 *   augment /nt:network-topology/nt:topology/nt:node {
 *     when ../../nt:topology-types/pn:topology-pcep;
 *     uses pcep-client-attributes;
 *     uses pdc:pcep-node-config;
 *   }
 *   typedef failure-type {
 *     type enumeration {
 *       enum unsent {
 *       }
 *       enum no-ack {
 *       }
 *       enum failed {
 *       }
 *     }
 *   }
 *   grouping node-id {
 *     leaf node {
 *       type nt:node-ref;
 *     }
 *   }
 *   grouping lsp-id {
 *     uses node-id;
 *     leaf name {
 *       type string;
 *     }
 *   }
 *   grouping operation-result {
 *     leaf failure {
 *       type failure-type;
 *     }
 *     list error {
 *       when "../failure = failed";
 *       uses pcep:pcep-error-object;
 *     }
 *   }
 *   grouping lsp-metadata {
 *     container metadata {
 *     }
 *   }
 *   grouping add-lsp-args {
 *     uses lsp-id;
 *     container arguments {
 *       uses pcep:endpoints-object;
 *       uses pcep:path-definition;
 *       uses lsp-metadata;
 *     }
 *   }
 *   rpc add-lsp {
 *     input input {
 *       uses ont:network-topology-reference;
 *       uses add-lsp-args;
 *     }
 *     output output {
 *       uses operation-result;
 *     }
 *   }
 *   grouping remove-lsp-args {
 *     uses lsp-id;
 *   }
 *   rpc remove-lsp {
 *     input input {
 *       uses ont:network-topology-reference;
 *       uses remove-lsp-args;
 *     }
 *     output output {
 *       uses operation-result;
 *     }
 *   }
 *   grouping update-lsp-args {
 *     uses lsp-id;
 *     container arguments {
 *       uses pcep:path-definition;
 *       uses lsp-metadata;
 *     }
 *   }
 *   rpc update-lsp {
 *     input input {
 *       uses ont:network-topology-reference;
 *       uses update-lsp-args;
 *     }
 *     output output {
 *       uses operation-result;
 *     }
 *   }
 *   grouping ensure-lsp-operational-args {
 *     uses lsp-id;
 *     container arguments;
 *   }
 *   rpc ensure-lsp-operational {
 *     input input {
 *       uses ont:network-topology-reference;
 *       uses ensure-lsp-operational-args;
 *     }
 *     output output {
 *       uses operation-result;
 *     }
 *   }
 *   grouping trigger-sync-args {
 *     uses lsp-id {
 *       refine name {
 *         mandatory false;
 *       }
 *     }
 *   }
 *   rpc trigger-sync {
 *     input input {
 *       uses ont:network-topology-reference;
 *       uses trigger-sync-args;
 *     }
 *     output output {
 *       uses operation-result;
 *     }
 *   }
 *   rpc tear-down-session {
 *     input input {
 *       uses ont:network-topology-reference;
 *       uses node-id;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface NetworkTopologyPcepData
    extends
    DataRoot
{





}

