package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * typedef pcc-sync-state {
 *   type enumeration {
 *     enum initial-resync {
 *     }
 *     enum incremental-sync {
 *     }
 *     enum triggered-initial-sync {
 *     }
 *     enum pcep-triggered-resync {
 *     }
 *     enum synchronized {
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public enum PccSyncState implements EnumTypeObject {
    /**
     * Initial state resynchronization is being performed.
     */
    InitialResync(0, "initial-resync"),
    
    /**
     * Incremental state resynchronization is being performed.
     */
    IncrementalSync(1, "incremental-sync"),
    
    /**
     * Triggered initial state resynchronization is being performed.
     */
    TriggeredInitialSync(2, "triggered-initial-sync"),
    
    /**
     * Pcep triggered state resynchronization is being performed.
     */
    PcepTriggeredResync(3, "pcep-triggered-resync"),
    
    /**
     * State synchronization has been achieved.
     */
    Synchronized(4, "synchronized")
    ;

    private final @NonNull String name;
    private final int value;

    private PccSyncState(int value, @NonNull String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public @NonNull String getName() {
        return name;
    }

    @Override
    public int getIntValue() {
        return value;
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding PccSyncState item, or {@code null} if no such item exists
     * @throws NullPointerException if {@code name} is null
     */
    public static @Nullable PccSyncState forName(String name) {
        return switch (name) {
            case "initial-resync" -> InitialResync;
            case "incremental-sync" -> IncrementalSync;
            case "triggered-initial-sync" -> TriggeredInitialSync;
            case "pcep-triggered-resync" -> PcepTriggeredResync;
            case "synchronized" -> Synchronized;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding PccSyncState item, or {@code null} if no such item exists
     */
    public static @Nullable PccSyncState forValue(int intValue) {
        return switch (intValue) {
            case 0 -> InitialResync;
            case 1 -> IncrementalSync;
            case 2 -> TriggeredInitialSync;
            case 3 -> PcepTriggeredResync;
            case 4 -> Synchronized;
            default -> null;
        };
    }

    /**
     * Return the enumeration member whose {@link #getName()} matches specified assigned name.
     *
     * @param name YANG assigned name
     * @return corresponding PccSyncState item
     * @throws NullPointerException if {@code name} is null
     * @throws IllegalArgumentException if {@code name} does not match any item
     */
    public static @NonNull PccSyncState ofName(String name) {
        return CodeHelpers.checkEnum(forName(name), name);
    }

    /**
     * Return the enumeration member whose {@link #getIntValue()} matches specified value.
     *
     * @param intValue integer value
     * @return corresponding PccSyncState item
     * @throws IllegalArgumentException if {@code intValue} does not match any item
     */
    public static @NonNull PccSyncState ofValue(int intValue) {
        return CodeHelpers.checkEnum(forValue(intValue), intValue);
    }
}
