package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.topology.rev140113.NetworkTopologyReference;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link TriggerSyncInput} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     TriggerSyncInput createTriggerSyncInput(int fooXyzzy, int barBaz) {
 *         return new TriggerSyncInputBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of TriggerSyncInput, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see TriggerSyncInput
 *
 */
@Generated("mdsal-binding-generator")
public class TriggerSyncInputBuilder {

    private String _name;
    private NetworkTopologyRef _networkTopologyRef;
    private NodeId _node;


    Map<Class<? extends Augmentation<TriggerSyncInput>>, Augmentation<TriggerSyncInput>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TriggerSyncInputBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link NetworkTopologyReference}.
     *
     * @param arg NetworkTopologyReference from which the builder should be initialized
     */
    public TriggerSyncInputBuilder(NetworkTopologyReference arg) {
        this._networkTopologyRef = arg.getNetworkTopologyRef();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link TriggerSyncArgs}.
     *
     * @param arg TriggerSyncArgs from which the builder should be initialized
     */
    public TriggerSyncInputBuilder(TriggerSyncArgs arg) {
        this._name = arg.getName();
        this._node = arg.getNode();
    }
    
    /**
     * Construct a new builder initialized from specified {@link LspId}.
     *
     * @param arg LspId from which the builder should be initialized
     */
    public TriggerSyncInputBuilder(LspId arg) {
        this._name = arg.getName();
        this._node = arg.getNode();
    }
    
    /**
     * Construct a new builder initialized from specified {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId}.
     *
     * @param arg org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId from which the builder should be initialized
     */
    public TriggerSyncInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId arg) {
        this._node = arg.getNode();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link TriggerSyncInput}.
     *
     * @param base TriggerSyncInput from which the builder should be initialized
     */
    public TriggerSyncInputBuilder(TriggerSyncInput base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._name = base.getName();
        this._networkTopologyRef = base.getNetworkTopologyRef();
        this._node = base.getNode();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link LspId}</li>
     *   <li>{@link NetworkTopologyReference}</li>
     *   <li>{@link TriggerSyncArgs}</li>
     *   <li>{@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LspId castArg) {
            this._name = castArg.getName();
            isValidArg = true;
        }
        if (arg instanceof NetworkTopologyReference castArg) {
            this._networkTopologyRef = castArg.getNetworkTopologyRef();
            isValidArg = true;
        }
        if (arg instanceof TriggerSyncArgs castArg) {
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId castArg) {
            this._node = castArg.getNode();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[LspId, NetworkTopologyReference, TriggerSyncArgs, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.NodeId]");
    }


    /**
     * Return current value associated with the property corresponding to {@link TriggerSyncInput#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TriggerSyncInput#getNetworkTopologyRef()}.
     *
     * @return current value
     */
    public NetworkTopologyRef getNetworkTopologyRef() {
        return _networkTopologyRef;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link TriggerSyncInput#getNode()}.
     *
     * @return current value
     */
    public NodeId getNode() {
        return _node;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<TriggerSyncInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link TriggerSyncInput#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TriggerSyncInputBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TriggerSyncInput#getNetworkTopologyRef()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TriggerSyncInputBuilder setNetworkTopologyRef(final NetworkTopologyRef value) {
        this._networkTopologyRef = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link TriggerSyncInput#getNode()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TriggerSyncInputBuilder setNode(final NodeId value) {
        this._node = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TriggerSyncInputBuilder addAugmentation(Augmentation<TriggerSyncInput> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TriggerSyncInputBuilder removeAugmentation(Class<? extends Augmentation<TriggerSyncInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link TriggerSyncInput} instance.
     *
     * @return A new {@link TriggerSyncInput} instance.
     */
    public @NonNull TriggerSyncInput build() {
        return new TriggerSyncInputImpl(this);
    }

    private static final class TriggerSyncInputImpl
        extends AbstractAugmentable<TriggerSyncInput>
        implements TriggerSyncInput {
    
        private final String _name;
        private final NetworkTopologyRef _networkTopologyRef;
        private final NodeId _node;
    
        TriggerSyncInputImpl(TriggerSyncInputBuilder base) {
            super(base.augmentation);
            this._name = base.getName();
            this._networkTopologyRef = base.getNetworkTopologyRef();
            this._node = base.getNode();
        }
    
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public NetworkTopologyRef getNetworkTopologyRef() {
            return _networkTopologyRef;
        }
        
        @Override
        public NodeId getNode() {
            return _node;
        }
    
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = TriggerSyncInput.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return TriggerSyncInput.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return TriggerSyncInput.bindingToString(this);
        }
    }
}
