package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClasstypeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExplicitRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.IncludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PathDefinition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Path} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Path createPath(int fooXyzzy, int barBaz) {
 *         return new PathBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Path, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Path
 *
 */
@Generated("mdsal-binding-generator")
public class PathBuilder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Ero _ero;
    private Iro _iro;
    private LspId _lspId;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private Rro _rro;
    private Xro _xro;
    private PathKey key;


    Map<Class<? extends Augmentation<Path>>, Augmentation<Path>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public PathBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PathDefinition}.
     *
     * @param arg PathDefinition from which the builder should be initialized
     */
    public PathBuilder(PathDefinition arg) {
        this._ero = arg.getEro();
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ExplicitRouteObject}.
     *
     * @param arg ExplicitRouteObject from which the builder should be initialized
     */
    public PathBuilder(ExplicitRouteObject arg) {
        this._ero = arg.getEro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link LspAttributes}.
     *
     * @param arg LspAttributes from which the builder should be initialized
     */
    public PathBuilder(LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    
    /**
     * Construct a new builder initialized from specified {@link LspaObject}.
     *
     * @param arg LspaObject from which the builder should be initialized
     */
    public PathBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }
    
    /**
     * Construct a new builder initialized from specified {@link BandwidthObject}.
     *
     * @param arg BandwidthObject from which the builder should be initialized
     */
    public PathBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ReoptimizationBandwidthObject}.
     *
     * @param arg ReoptimizationBandwidthObject from which the builder should be initialized
     */
    public PathBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }
    
    /**
     * Construct a new builder initialized from specified {@link IncludeRouteObject}.
     *
     * @param arg IncludeRouteObject from which the builder should be initialized
     */
    public PathBuilder(IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ReportedRouteObject}.
     *
     * @param arg ReportedRouteObject from which the builder should be initialized
     */
    public PathBuilder(ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ExcludeRouteObject}.
     *
     * @param arg ExcludeRouteObject from which the builder should be initialized
     */
    public PathBuilder(ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link OfObject}.
     *
     * @param arg OfObject from which the builder should be initialized
     */
    public PathBuilder(OfObject arg) {
        this._of = arg.getOf();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ClasstypeObject}.
     *
     * @param arg ClasstypeObject from which the builder should be initialized
     */
    public PathBuilder(ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Path}.
     *
     * @param base Path from which the builder should be initialized
     */
    public PathBuilder(Path base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._lspId = base.getLspId();
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._ero = base.getEro();
        this._iro = base.getIro();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._rro = base.getRro();
        this._xro = base.getXro();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link ClasstypeObject}</li>
     *   <li>{@link ReoptimizationBandwidthObject}</li>
     *   <li>{@link BandwidthObject}</li>
     *   <li>{@link OfObject}</li>
     *   <li>{@link PathDefinition}</li>
     *   <li>{@link ReportedRouteObject}</li>
     *   <li>{@link LspAttributes}</li>
     *   <li>{@link IncludeRouteObject}</li>
     *   <li>{@link ExcludeRouteObject}</li>
     *   <li>{@link LspaObject}</li>
     *   <li>{@link ExplicitRouteObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ClasstypeObject castArg) {
            this._classType = castArg.getClassType();
            isValidArg = true;
        }
        if (arg instanceof ReoptimizationBandwidthObject castArg) {
            this._reoptimizationBandwidth = castArg.getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BandwidthObject castArg) {
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject castArg) {
            this._of = castArg.getOf();
            isValidArg = true;
        }
        if (arg instanceof PathDefinition castArg) {
            isValidArg = true;
        }
        if (arg instanceof ReportedRouteObject castArg) {
            this._rro = castArg.getRro();
            isValidArg = true;
        }
        if (arg instanceof LspAttributes castArg) {
            this._metrics = castArg.getMetrics();
            isValidArg = true;
        }
        if (arg instanceof IncludeRouteObject castArg) {
            this._iro = castArg.getIro();
            isValidArg = true;
        }
        if (arg instanceof ExcludeRouteObject castArg) {
            this._xro = castArg.getXro();
            isValidArg = true;
        }
        if (arg instanceof LspaObject castArg) {
            this._lspa = castArg.getLspa();
            isValidArg = true;
        }
        if (arg instanceof ExplicitRouteObject castArg) {
            this._ero = castArg.getEro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ClasstypeObject, ReoptimizationBandwidthObject, BandwidthObject, OfObject, PathDefinition, ReportedRouteObject, LspAttributes, IncludeRouteObject, ExcludeRouteObject, LspaObject, ExplicitRouteObject]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Path#key()}.
     *
     * @return current value
     */
    public PathKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getClassType()}.
     *
     * @return current value
     */
    public ClassType getClassType() {
        return _classType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getEro()}.
     *
     * @return current value
     */
    public Ero getEro() {
        return _ero;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getIro()}.
     *
     * @return current value
     */
    public Iro getIro() {
        return _iro;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getLspId()}.
     *
     * @return current value
     */
    public LspId getLspId() {
        return _lspId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getLspa()}.
     *
     * @return current value
     */
    public Lspa getLspa() {
        return _lspa;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getMetrics()}.
     *
     * @return current value
     */
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getOf()}.
     *
     * @return current value
     */
    public Of getOf() {
        return _of;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getReoptimizationBandwidth()}.
     *
     * @return current value
     */
    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getRro()}.
     *
     * @return current value
     */
    public Rro getRro() {
        return _rro;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Path#getXro()}.
     *
     * @return current value
     */
    public Xro getXro() {
        return _xro;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Path>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Path#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public PathBuilder withKey(final PathKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getEro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setEro(final Ero value) {
        this._ero = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getIro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setIro(final Iro value) {
        this._iro = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getLspId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setLspId(final LspId value) {
        this._lspId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getLspa()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setLspa(final Lspa value) {
        this._lspa = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getMetrics()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PathBuilder setMetrics(final List<Metrics> values) {
        this._metrics = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Path#getOf()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getReoptimizationBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getRro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setRro(final Rro value) {
        this._rro = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Path#getXro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PathBuilder setXro(final Xro value) {
        this._xro = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PathBuilder addAugmentation(Augmentation<Path> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PathBuilder removeAugmentation(Class<? extends Augmentation<Path>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Path} instance.
     *
     * @return A new {@link Path} instance.
     */
    public @NonNull Path build() {
        return new PathImpl(this);
    }

    private static final class PathImpl
        extends AbstractAugmentable<Path>
        implements Path {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Ero _ero;
        private final Iro _iro;
        private final LspId _lspId;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final Rro _rro;
        private final Xro _xro;
        private final PathKey key;
    
        PathImpl(PathBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new PathKey(base.getLspId());
            }
            this._lspId = key.getLspId();
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._ero = base.getEro();
            this._iro = base.getIro();
            this._lspa = base.getLspa();
            this._metrics = CodeHelpers.emptyToNull(base.getMetrics());
            this._of = base.getOf();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._rro = base.getRro();
            this._xro = base.getXro();
        }
    
        @Override
        public PathKey key() {
            return key;
        }
        
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Ero getEro() {
            return _ero;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public LspId getLspId() {
            return _lspId;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
    
        @Override
        public Bandwidth nonnullBandwidth() {
            return Objects.requireNonNullElse(getBandwidth(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder.empty());
        }
        
        @Override
        public ClassType nonnullClassType() {
            return Objects.requireNonNullElse(getClassType(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassTypeBuilder.empty());
        }
        
        @Override
        public Ero nonnullEro() {
            return Objects.requireNonNullElse(getEro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder.empty());
        }
        
        @Override
        public Iro nonnullIro() {
            return Objects.requireNonNullElse(getIro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.IroBuilder.empty());
        }
        
        
        @Override
        public Lspa nonnullLspa() {
            return Objects.requireNonNullElse(getLspa(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder.empty());
        }
        
        
        @Override
        public Of nonnullOf() {
            return Objects.requireNonNullElse(getOf(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder.empty());
        }
        
        @Override
        public ReoptimizationBandwidth nonnullReoptimizationBandwidth() {
            return Objects.requireNonNullElse(getReoptimizationBandwidth(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidthBuilder.empty());
        }
        
        @Override
        public Rro nonnullRro() {
            return Objects.requireNonNullElse(getRro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder.empty());
        }
        
        @Override
        public Xro nonnullXro() {
            return Objects.requireNonNullElse(getXro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.XroBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Path.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Path.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Path.bindingToString(this);
        }
    }
}
