package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PathDefinition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.LspMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.UpdateLspArgs;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>network-topology-pcep</b>
 * <pre>
 * container arguments {
 *   uses pcep:path-definition;
 *   uses lsp-metadata;
 * }
 * </pre>
 * <p>To create instances of this class use {@link ArgumentsBuilder}.
 * @see ArgumentsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Arguments
    extends
    ChildOf<UpdateLspArgs>,
    Augmentable<Arguments>,
    PathDefinition,
    LspMetadata
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("arguments");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args.Arguments> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args.Arguments.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args.@NonNull Arguments obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getBandwidth());
        result = prime * result + Objects.hashCode(obj.getClassType());
        result = prime * result + Objects.hashCode(obj.getEro());
        result = prime * result + Objects.hashCode(obj.getIro());
        result = prime * result + Objects.hashCode(obj.getLspa());
        result = prime * result + Objects.hashCode(obj.getMetadata());
        result = prime * result + Objects.hashCode(obj.getMetrics());
        result = prime * result + Objects.hashCode(obj.getOf());
        result = prime * result + Objects.hashCode(obj.getReoptimizationBandwidth());
        result = prime * result + Objects.hashCode(obj.getRro());
        result = prime * result + Objects.hashCode(obj.getXro());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args.@NonNull Arguments thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args.Arguments.class, obj);
        return other != null
            && Objects.equals(thisObj.getBandwidth(), other.getBandwidth())
            && Objects.equals(thisObj.getClassType(), other.getClassType())
            && Objects.equals(thisObj.getEro(), other.getEro())
            && Objects.equals(thisObj.getIro(), other.getIro())
            && Objects.equals(thisObj.getLspa(), other.getLspa())
            && Objects.equals(thisObj.getMetadata(), other.getMetadata())
            && Objects.equals(thisObj.getMetrics(), other.getMetrics())
            && Objects.equals(thisObj.getOf(), other.getOf())
            && Objects.equals(thisObj.getReoptimizationBandwidth(), other.getReoptimizationBandwidth())
            && Objects.equals(thisObj.getRro(), other.getRro())
            && Objects.equals(thisObj.getXro(), other.getXro())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args.@NonNull Arguments obj) {
        final var helper = MoreObjects.toStringHelper("Arguments");
        CodeHelpers.appendValue(helper, "bandwidth", obj.getBandwidth());
        CodeHelpers.appendValue(helper, "classType", obj.getClassType());
        CodeHelpers.appendValue(helper, "ero", obj.getEro());
        CodeHelpers.appendValue(helper, "iro", obj.getIro());
        CodeHelpers.appendValue(helper, "lspa", obj.getLspa());
        CodeHelpers.appendValue(helper, "metadata", obj.getMetadata());
        CodeHelpers.appendValue(helper, "metrics", obj.getMetrics());
        CodeHelpers.appendValue(helper, "of", obj.getOf());
        CodeHelpers.appendValue(helper, "reoptimizationBandwidth", obj.getReoptimizationBandwidth());
        CodeHelpers.appendValue(helper, "rro", obj.getRro());
        CodeHelpers.appendValue(helper, "xro", obj.getXro());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

