package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.update.lsp.args;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClasstypeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExplicitRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.IncludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PathDefinition;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.LspMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.lsp.metadata.Metadata;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Arguments} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Arguments createArguments(int fooXyzzy, int barBaz) {
 *         return new ArgumentsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Arguments, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Arguments
 *
 */
@Generated("mdsal-binding-generator")
public class ArgumentsBuilder {

    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Ero _ero;
    private Iro _iro;
    private Lspa _lspa;
    private Metadata _metadata;
    private List<Metrics> _metrics;
    private Of _of;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private Rro _rro;
    private Xro _xro;


    Map<Class<? extends Augmentation<Arguments>>, Augmentation<Arguments>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ArgumentsBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link PathDefinition}.
     *
     * @param arg PathDefinition from which the builder should be initialized
     */
    public ArgumentsBuilder(PathDefinition arg) {
        this._ero = arg.getEro();
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ExplicitRouteObject}.
     *
     * @param arg ExplicitRouteObject from which the builder should be initialized
     */
    public ArgumentsBuilder(ExplicitRouteObject arg) {
        this._ero = arg.getEro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link LspAttributes}.
     *
     * @param arg LspAttributes from which the builder should be initialized
     */
    public ArgumentsBuilder(LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }
    
    /**
     * Construct a new builder initialized from specified {@link LspaObject}.
     *
     * @param arg LspaObject from which the builder should be initialized
     */
    public ArgumentsBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }
    
    /**
     * Construct a new builder initialized from specified {@link BandwidthObject}.
     *
     * @param arg BandwidthObject from which the builder should be initialized
     */
    public ArgumentsBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ReoptimizationBandwidthObject}.
     *
     * @param arg ReoptimizationBandwidthObject from which the builder should be initialized
     */
    public ArgumentsBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }
    
    /**
     * Construct a new builder initialized from specified {@link IncludeRouteObject}.
     *
     * @param arg IncludeRouteObject from which the builder should be initialized
     */
    public ArgumentsBuilder(IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ReportedRouteObject}.
     *
     * @param arg ReportedRouteObject from which the builder should be initialized
     */
    public ArgumentsBuilder(ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ExcludeRouteObject}.
     *
     * @param arg ExcludeRouteObject from which the builder should be initialized
     */
    public ArgumentsBuilder(ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }
    
    /**
     * Construct a new builder initialized from specified {@link OfObject}.
     *
     * @param arg OfObject from which the builder should be initialized
     */
    public ArgumentsBuilder(OfObject arg) {
        this._of = arg.getOf();
    }
    
    /**
     * Construct a new builder initialized from specified {@link ClasstypeObject}.
     *
     * @param arg ClasstypeObject from which the builder should be initialized
     */
    public ArgumentsBuilder(ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link LspMetadata}.
     *
     * @param arg LspMetadata from which the builder should be initialized
     */
    public ArgumentsBuilder(LspMetadata arg) {
        this._metadata = arg.getMetadata();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Arguments}.
     *
     * @param base Arguments from which the builder should be initialized
     */
    public ArgumentsBuilder(Arguments base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._ero = base.getEro();
        this._iro = base.getIro();
        this._lspa = base.getLspa();
        this._metadata = base.getMetadata();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._rro = base.getRro();
        this._xro = base.getXro();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link ClasstypeObject}</li>
     *   <li>{@link ReoptimizationBandwidthObject}</li>
     *   <li>{@link BandwidthObject}</li>
     *   <li>{@link OfObject}</li>
     *   <li>{@link PathDefinition}</li>
     *   <li>{@link ReportedRouteObject}</li>
     *   <li>{@link LspAttributes}</li>
     *   <li>{@link IncludeRouteObject}</li>
     *   <li>{@link ExcludeRouteObject}</li>
     *   <li>{@link LspaObject}</li>
     *   <li>{@link LspMetadata}</li>
     *   <li>{@link ExplicitRouteObject}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ClasstypeObject castArg) {
            this._classType = castArg.getClassType();
            isValidArg = true;
        }
        if (arg instanceof ReoptimizationBandwidthObject castArg) {
            this._reoptimizationBandwidth = castArg.getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BandwidthObject castArg) {
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject castArg) {
            this._of = castArg.getOf();
            isValidArg = true;
        }
        if (arg instanceof PathDefinition castArg) {
            isValidArg = true;
        }
        if (arg instanceof ReportedRouteObject castArg) {
            this._rro = castArg.getRro();
            isValidArg = true;
        }
        if (arg instanceof LspAttributes castArg) {
            this._metrics = castArg.getMetrics();
            isValidArg = true;
        }
        if (arg instanceof IncludeRouteObject castArg) {
            this._iro = castArg.getIro();
            isValidArg = true;
        }
        if (arg instanceof ExcludeRouteObject castArg) {
            this._xro = castArg.getXro();
            isValidArg = true;
        }
        if (arg instanceof LspaObject castArg) {
            this._lspa = castArg.getLspa();
            isValidArg = true;
        }
        if (arg instanceof LspMetadata castArg) {
            this._metadata = castArg.getMetadata();
            isValidArg = true;
        }
        if (arg instanceof ExplicitRouteObject castArg) {
            this._ero = castArg.getEro();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[ClasstypeObject, ReoptimizationBandwidthObject, BandwidthObject, OfObject, PathDefinition, ReportedRouteObject, LspAttributes, IncludeRouteObject, ExcludeRouteObject, LspaObject, LspMetadata, ExplicitRouteObject]");
    }

    private static final class LazyEmpty {
        static final @NonNull Arguments INSTANCE = new ArgumentsBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Arguments.
     *
     * @return An empty {@link Arguments}
     */
    public static @NonNull Arguments empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Arguments#getBandwidth()}.
     *
     * @return current value
     */
    public Bandwidth getBandwidth() {
        return _bandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getClassType()}.
     *
     * @return current value
     */
    public ClassType getClassType() {
        return _classType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getEro()}.
     *
     * @return current value
     */
    public Ero getEro() {
        return _ero;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getIro()}.
     *
     * @return current value
     */
    public Iro getIro() {
        return _iro;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getLspa()}.
     *
     * @return current value
     */
    public Lspa getLspa() {
        return _lspa;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getMetadata()}.
     *
     * @return current value
     */
    public Metadata getMetadata() {
        return _metadata;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getMetrics()}.
     *
     * @return current value
     */
    public List<Metrics> getMetrics() {
        return _metrics;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getOf()}.
     *
     * @return current value
     */
    public Of getOf() {
        return _of;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getReoptimizationBandwidth()}.
     *
     * @return current value
     */
    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return _reoptimizationBandwidth;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getRro()}.
     *
     * @return current value
     */
    public Rro getRro() {
        return _rro;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Arguments#getXro()}.
     *
     * @return current value
     */
    public Xro getXro() {
        return _xro;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Arguments>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Arguments#getBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setBandwidth(final Bandwidth value) {
        this._bandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getClassType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setClassType(final ClassType value) {
        this._classType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getEro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setEro(final Ero value) {
        this._ero = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getIro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setIro(final Iro value) {
        this._iro = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getLspa()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setLspa(final Lspa value) {
        this._lspa = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getMetadata()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setMetadata(final Metadata value) {
        this._metadata = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getMetrics()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public ArgumentsBuilder setMetrics(final List<Metrics> values) {
        this._metrics = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Arguments#getOf()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setOf(final Of value) {
        this._of = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getReoptimizationBandwidth()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setReoptimizationBandwidth(final ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getRro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setRro(final Rro value) {
        this._rro = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Arguments#getXro()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ArgumentsBuilder setXro(final Xro value) {
        this._xro = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ArgumentsBuilder addAugmentation(Augmentation<Arguments> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ArgumentsBuilder removeAugmentation(Class<? extends Augmentation<Arguments>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Arguments} instance.
     *
     * @return A new {@link Arguments} instance.
     */
    public @NonNull Arguments build() {
        return new ArgumentsImpl(this);
    }

    private static final class ArgumentsImpl
        extends AbstractAugmentable<Arguments>
        implements Arguments {
    
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Ero _ero;
        private final Iro _iro;
        private final Lspa _lspa;
        private final Metadata _metadata;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final Rro _rro;
        private final Xro _xro;
    
        ArgumentsImpl(ArgumentsBuilder base) {
            super(base.augmentation);
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._ero = base.getEro();
            this._iro = base.getIro();
            this._lspa = base.getLspa();
            this._metadata = base.getMetadata();
            this._metrics = CodeHelpers.emptyToNull(base.getMetrics());
            this._of = base.getOf();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._rro = base.getRro();
            this._xro = base.getXro();
        }
    
        @Override
        public Bandwidth getBandwidth() {
            return _bandwidth;
        }
        
        @Override
        public ClassType getClassType() {
            return _classType;
        }
        
        @Override
        public Ero getEro() {
            return _ero;
        }
        
        @Override
        public Iro getIro() {
            return _iro;
        }
        
        @Override
        public Lspa getLspa() {
            return _lspa;
        }
        
        @Override
        public Metadata getMetadata() {
            return _metadata;
        }
        
        @Override
        public List<Metrics> getMetrics() {
            return _metrics;
        }
        
        @Override
        public Of getOf() {
            return _of;
        }
        
        @Override
        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return _reoptimizationBandwidth;
        }
        
        @Override
        public Rro getRro() {
            return _rro;
        }
        
        @Override
        public Xro getXro() {
            return _xro;
        }
    
        @Override
        public Bandwidth nonnullBandwidth() {
            return Objects.requireNonNullElse(getBandwidth(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder.empty());
        }
        
        @Override
        public ClassType nonnullClassType() {
            return Objects.requireNonNullElse(getClassType(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassTypeBuilder.empty());
        }
        
        @Override
        public Ero nonnullEro() {
            return Objects.requireNonNullElse(getEro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder.empty());
        }
        
        @Override
        public Iro nonnullIro() {
            return Objects.requireNonNullElse(getIro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.IroBuilder.empty());
        }
        
        @Override
        public Lspa nonnullLspa() {
            return Objects.requireNonNullElse(getLspa(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder.empty());
        }
        
        @Override
        public Metadata nonnullMetadata() {
            return Objects.requireNonNullElse(getMetadata(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.lsp.metadata.MetadataBuilder.empty());
        }
        
        
        @Override
        public Of nonnullOf() {
            return Objects.requireNonNullElse(getOf(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder.empty());
        }
        
        @Override
        public ReoptimizationBandwidth nonnullReoptimizationBandwidth() {
            return Objects.requireNonNullElse(getReoptimizationBandwidth(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidthBuilder.empty());
        }
        
        @Override
        public Rro nonnullRro() {
            return Objects.requireNonNullElse(getRro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder.empty());
        }
        
        @Override
        public Xro nonnullXro() {
            return Objects.requireNonNullElse(getXro(), org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.XroBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Arguments.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Arguments.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Arguments.bindingToString(this);
        }
    }
}
