/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;

public class NodeBuilder {
    private NodeId _nodeId;
    private NodeKey key;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Map.of();

    public NodeBuilder() {
    }

    public NodeBuilder(Node base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(aug);
        }
        this.key = base.key();
        this._nodeId = base.getNodeId();
    }

    public NodeKey key() {
        return this.key;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public <E$$ extends Augmentation<Node>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodeBuilder withKey(NodeKey key) {
        this.key = key;
        return this;
    }

    public NodeBuilder setNodeId(NodeId value) {
        this._nodeId = value;
        return this;
    }

    public NodeBuilder addAugmentation(Augmentation<Node> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public NodeBuilder removeAugmentation(Class<? extends Augmentation<Node>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    extends AbstractEntryObject<Node, NodeKey>
    implements Node {
        private final NodeId _nodeId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeImpl(NodeBuilder base) {
            super(base.augmentation, (Key)NodeImpl.extractKey(base));
            NodeKey key = (NodeKey)this.key();
            this._nodeId = key.getNodeId();
        }

        private static @NonNull NodeKey extractKey(NodeBuilder base) {
            NodeKey key = base.key();
            return key != null ? key : new NodeKey(base.getNodeId());
        }

        @Override
        public NodeId getNodeId() {
            return this._nodeId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Node.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Node.bindingEquals(this, obj);
        }

        public String toString() {
            return Node.bindingToString(this);
        }
    }
}

