/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.PcepNodeConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.node.config.SessionConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.config.rev230112.pcep.node.config.SessionConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.Node1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.PcepClientAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.PathComputationClientBuilder;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class Node1Builder {
    private PathComputationClient _pathComputationClient;
    private SessionConfig _sessionConfig;

    public Node1Builder() {
    }

    public Node1Builder(PcepClientAttributes arg) {
        this._pathComputationClient = arg.getPathComputationClient();
    }

    public Node1Builder(PcepNodeConfig arg) {
        this._sessionConfig = arg.getSessionConfig();
    }

    public Node1Builder(Node1 base) {
        this._pathComputationClient = base.getPathComputationClient();
        this._sessionConfig = base.getSessionConfig();
    }

    public void fieldsFrom(Grouping arg) {
        PcepClientAttributes castArg;
        boolean isValidArg = false;
        if (arg instanceof PcepClientAttributes) {
            castArg = (PcepClientAttributes)arg;
            this._pathComputationClient = castArg.getPathComputationClient();
            isValidArg = true;
        }
        if (arg instanceof PcepNodeConfig) {
            castArg = (PcepNodeConfig)arg;
            this._sessionConfig = castArg.getSessionConfig();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[PcepClientAttributes, PcepNodeConfig]");
    }

    public PathComputationClient getPathComputationClient() {
        return this._pathComputationClient;
    }

    public SessionConfig getSessionConfig() {
        return this._sessionConfig;
    }

    public Node1Builder setPathComputationClient(PathComputationClient value) {
        this._pathComputationClient = value;
        return this;
    }

    public Node1Builder setSessionConfig(SessionConfig value) {
        this._sessionConfig = value;
        return this;
    }

    public @NonNull Node1 build() {
        return new Node1Impl(this);
    }

    private static final class Node1Impl
    implements Node1 {
        private final PathComputationClient _pathComputationClient;
        private final SessionConfig _sessionConfig;
        private int hash = 0;
        private volatile boolean hashValid = false;

        Node1Impl(Node1Builder base) {
            this._pathComputationClient = base.getPathComputationClient();
            this._sessionConfig = base.getSessionConfig();
        }

        @Override
        public PathComputationClient getPathComputationClient() {
            return this._pathComputationClient;
        }

        public SessionConfig getSessionConfig() {
            return this._sessionConfig;
        }

        @Override
        public PathComputationClient nonnullPathComputationClient() {
            return Objects.requireNonNullElse(this.getPathComputationClient(), PathComputationClientBuilder.empty());
        }

        public SessionConfig nonnullSessionConfig() {
            return Objects.requireNonNullElse(this.getSessionConfig(), SessionConfigBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Node1.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Node1.bindingEquals(this, obj);
        }

        public String toString() {
            return Node1.bindingToString(this);
        }
    }
}

