/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.LspMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.lsp.metadata.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.lsp.metadata.MetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.ReportedLspKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp.PathKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class ReportedLspBuilder {
    private Metadata _metadata;
    private String _name;
    private Map<PathKey, Path> _path;
    private ReportedLspKey key;
    Map<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>> augmentation = Map.of();

    public ReportedLspBuilder() {
    }

    public ReportedLspBuilder(LspMetadata arg) {
        this._metadata = arg.getMetadata();
    }

    public ReportedLspBuilder(ReportedLsp base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._metadata = base.getMetadata();
        this._path = base.getPath();
    }

    public void fieldsFrom(Grouping arg) {
        boolean isValidArg = false;
        if (arg instanceof LspMetadata) {
            LspMetadata castArg = (LspMetadata)arg;
            this._metadata = castArg.getMetadata();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LspMetadata]");
    }

    public ReportedLspKey key() {
        return this.key;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public String getName() {
        return this._name;
    }

    public Map<PathKey, Path> getPath() {
        return this._path;
    }

    public <E$$ extends Augmentation<ReportedLsp>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ReportedLspBuilder withKey(ReportedLspKey key) {
        this.key = key;
        return this;
    }

    public ReportedLspBuilder setMetadata(Metadata value) {
        this._metadata = value;
        return this;
    }

    public ReportedLspBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ReportedLspBuilder setPath(Map<PathKey, Path> values) {
        this._path = values;
        return this;
    }

    public ReportedLspBuilder addAugmentation(Augmentation<ReportedLsp> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ReportedLspBuilder removeAugmentation(Class<? extends Augmentation<ReportedLsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull ReportedLsp build() {
        return new ReportedLspImpl(this);
    }

    private static final class ReportedLspImpl
    extends AbstractEntryObject<ReportedLsp, ReportedLspKey>
    implements ReportedLsp {
        private final Metadata _metadata;
        private final String _name;
        private final Map<PathKey, Path> _path;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ReportedLspImpl(ReportedLspBuilder base) {
            super(base.augmentation, (Key)ReportedLspImpl.extractKey(base));
            ReportedLspKey key = (ReportedLspKey)this.key();
            this._name = key.getName();
            this._metadata = base.getMetadata();
            this._path = CodeHelpers.emptyToNull(base.getPath());
        }

        private static @NonNull ReportedLspKey extractKey(ReportedLspBuilder base) {
            ReportedLspKey key = base.key();
            return key != null ? key : new ReportedLspKey(base.getName());
        }

        @Override
        public Metadata getMetadata() {
            return this._metadata;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Map<PathKey, Path> getPath() {
            return this._path;
        }

        @Override
        public Metadata nonnullMetadata() {
            return Objects.requireNonNullElse(this.getMetadata(), MetadataBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = ReportedLsp.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return ReportedLsp.bindingEquals(this, obj);
        }

        public String toString() {
            return ReportedLsp.bindingToString(this);
        }
    }
}

