/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.BandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClasstypeObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExcludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ExplicitRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.IncludeRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.LspaObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReoptimizationBandwidthObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ReportedRouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.BandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.XroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.EroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.IroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidthBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev220730.pcep.client.attributes.path.computation.client.reported.lsp.PathKey;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class PathBuilder {
    private Bandwidth _bandwidth;
    private ClassType _classType;
    private Ero _ero;
    private Iro _iro;
    private LspId _lspId;
    private Lspa _lspa;
    private List<Metrics> _metrics;
    private Of _of;
    private ReoptimizationBandwidth _reoptimizationBandwidth;
    private Rro _rro;
    private Xro _xro;
    private PathKey key;
    Map<Class<? extends Augmentation<Path>>, Augmentation<Path>> augmentation = Map.of();

    public PathBuilder() {
    }

    public PathBuilder(ExplicitRouteObject arg) {
        this._ero = arg.getEro();
    }

    public PathBuilder(LspAttributes arg) {
        this._metrics = arg.getMetrics();
        this._lspa = arg.getLspa();
        this._bandwidth = arg.getBandwidth();
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
        this._iro = arg.getIro();
        this._rro = arg.getRro();
        this._xro = arg.getXro();
        this._of = arg.getOf();
        this._classType = arg.getClassType();
    }

    public PathBuilder(LspaObject arg) {
        this._lspa = arg.getLspa();
    }

    public PathBuilder(BandwidthObject arg) {
        this._bandwidth = arg.getBandwidth();
    }

    public PathBuilder(ReoptimizationBandwidthObject arg) {
        this._reoptimizationBandwidth = arg.getReoptimizationBandwidth();
    }

    public PathBuilder(IncludeRouteObject arg) {
        this._iro = arg.getIro();
    }

    public PathBuilder(ReportedRouteObject arg) {
        this._rro = arg.getRro();
    }

    public PathBuilder(ExcludeRouteObject arg) {
        this._xro = arg.getXro();
    }

    public PathBuilder(OfObject arg) {
        this._of = arg.getOf();
    }

    public PathBuilder(ClasstypeObject arg) {
        this._classType = arg.getClassType();
    }

    public PathBuilder(Path base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Path>>, Augmentation<Path>>(aug);
        }
        this.key = base.key();
        this._lspId = base.getLspId();
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._ero = base.getEro();
        this._iro = base.getIro();
        this._lspa = base.getLspa();
        this._metrics = base.getMetrics();
        this._of = base.getOf();
        this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
        this._rro = base.getRro();
        this._xro = base.getXro();
    }

    public void fieldsFrom(Grouping arg) {
        ClasstypeObject castArg;
        boolean isValidArg = false;
        if (arg instanceof ClasstypeObject) {
            castArg = (ClasstypeObject)arg;
            this._classType = castArg.getClassType();
            isValidArg = true;
        }
        if (arg instanceof ReoptimizationBandwidthObject) {
            castArg = (ReoptimizationBandwidthObject)arg;
            this._reoptimizationBandwidth = castArg.getReoptimizationBandwidth();
            isValidArg = true;
        }
        if (arg instanceof BandwidthObject) {
            castArg = (BandwidthObject)arg;
            this._bandwidth = castArg.getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof OfObject) {
            castArg = (OfObject)arg;
            this._of = castArg.getOf();
            isValidArg = true;
        }
        if (arg instanceof ReportedRouteObject) {
            castArg = (ReportedRouteObject)arg;
            this._rro = castArg.getRro();
            isValidArg = true;
        }
        if (arg instanceof LspAttributes) {
            castArg = (LspAttributes)arg;
            this._metrics = castArg.getMetrics();
            isValidArg = true;
        }
        if (arg instanceof IncludeRouteObject) {
            castArg = (IncludeRouteObject)arg;
            this._iro = castArg.getIro();
            isValidArg = true;
        }
        if (arg instanceof ExcludeRouteObject) {
            castArg = (ExcludeRouteObject)arg;
            this._xro = castArg.getXro();
            isValidArg = true;
        }
        if (arg instanceof LspaObject) {
            castArg = (LspaObject)arg;
            this._lspa = castArg.getLspa();
            isValidArg = true;
        }
        if (arg instanceof ExplicitRouteObject) {
            castArg = (ExplicitRouteObject)arg;
            this._ero = castArg.getEro();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[ClasstypeObject, ReoptimizationBandwidthObject, BandwidthObject, OfObject, ReportedRouteObject, LspAttributes, IncludeRouteObject, ExcludeRouteObject, LspaObject, ExplicitRouteObject]");
    }

    public PathKey key() {
        return this.key;
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public ClassType getClassType() {
        return this._classType;
    }

    public Ero getEro() {
        return this._ero;
    }

    public Iro getIro() {
        return this._iro;
    }

    public LspId getLspId() {
        return this._lspId;
    }

    public Lspa getLspa() {
        return this._lspa;
    }

    public List<Metrics> getMetrics() {
        return this._metrics;
    }

    public Of getOf() {
        return this._of;
    }

    public ReoptimizationBandwidth getReoptimizationBandwidth() {
        return this._reoptimizationBandwidth;
    }

    public Rro getRro() {
        return this._rro;
    }

    public Xro getXro() {
        return this._xro;
    }

    public <E$$ extends Augmentation<Path>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public PathBuilder withKey(PathKey key) {
        this.key = key;
        return this;
    }

    public PathBuilder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public PathBuilder setClassType(ClassType value) {
        this._classType = value;
        return this;
    }

    public PathBuilder setEro(Ero value) {
        this._ero = value;
        return this;
    }

    public PathBuilder setIro(Iro value) {
        this._iro = value;
        return this;
    }

    public PathBuilder setLspId(LspId value) {
        this._lspId = value;
        return this;
    }

    public PathBuilder setLspa(Lspa value) {
        this._lspa = value;
        return this;
    }

    public PathBuilder setMetrics(List<Metrics> values) {
        this._metrics = values;
        return this;
    }

    public PathBuilder setOf(Of value) {
        this._of = value;
        return this;
    }

    public PathBuilder setReoptimizationBandwidth(ReoptimizationBandwidth value) {
        this._reoptimizationBandwidth = value;
        return this;
    }

    public PathBuilder setRro(Rro value) {
        this._rro = value;
        return this;
    }

    public PathBuilder setXro(Xro value) {
        this._xro = value;
        return this;
    }

    public PathBuilder addAugmentation(Augmentation<Path> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Path>>, Augmentation<Path>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public PathBuilder removeAugmentation(Class<? extends Augmentation<Path>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Path build() {
        return new PathImpl(this);
    }

    private static final class PathImpl
    extends AbstractEntryObject<Path, PathKey>
    implements Path {
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final Ero _ero;
        private final Iro _iro;
        private final LspId _lspId;
        private final Lspa _lspa;
        private final List<Metrics> _metrics;
        private final Of _of;
        private final ReoptimizationBandwidth _reoptimizationBandwidth;
        private final Rro _rro;
        private final Xro _xro;
        private int hash = 0;
        private volatile boolean hashValid = false;

        PathImpl(PathBuilder base) {
            super(base.augmentation, (Key)PathImpl.extractKey(base));
            PathKey key = (PathKey)this.key();
            this._lspId = key.getLspId();
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._ero = base.getEro();
            this._iro = base.getIro();
            this._lspa = base.getLspa();
            this._metrics = CodeHelpers.emptyToNull(base.getMetrics());
            this._of = base.getOf();
            this._reoptimizationBandwidth = base.getReoptimizationBandwidth();
            this._rro = base.getRro();
            this._xro = base.getXro();
        }

        private static @NonNull PathKey extractKey(PathBuilder base) {
            PathKey key = base.key();
            return key != null ? key : new PathKey(base.getLspId());
        }

        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        public ClassType getClassType() {
            return this._classType;
        }

        public Ero getEro() {
            return this._ero;
        }

        public Iro getIro() {
            return this._iro;
        }

        @Override
        public LspId getLspId() {
            return this._lspId;
        }

        public Lspa getLspa() {
            return this._lspa;
        }

        public List<Metrics> getMetrics() {
            return this._metrics;
        }

        public Of getOf() {
            return this._of;
        }

        public ReoptimizationBandwidth getReoptimizationBandwidth() {
            return this._reoptimizationBandwidth;
        }

        public Rro getRro() {
            return this._rro;
        }

        public Xro getXro() {
            return this._xro;
        }

        public Bandwidth nonnullBandwidth() {
            return Objects.requireNonNullElse(this.getBandwidth(), BandwidthBuilder.empty());
        }

        public ClassType nonnullClassType() {
            return Objects.requireNonNullElse(this.getClassType(), ClassTypeBuilder.empty());
        }

        public Ero nonnullEro() {
            return Objects.requireNonNullElse(this.getEro(), EroBuilder.empty());
        }

        public Iro nonnullIro() {
            return Objects.requireNonNullElse(this.getIro(), IroBuilder.empty());
        }

        public Lspa nonnullLspa() {
            return Objects.requireNonNullElse(this.getLspa(), LspaBuilder.empty());
        }

        public Of nonnullOf() {
            return Objects.requireNonNullElse(this.getOf(), OfBuilder.empty());
        }

        public ReoptimizationBandwidth nonnullReoptimizationBandwidth() {
            return Objects.requireNonNullElse(this.getReoptimizationBandwidth(), ReoptimizationBandwidthBuilder.empty());
        }

        public Rro nonnullRro() {
            return Objects.requireNonNullElse(this.getRro(), RroBuilder.empty());
        }

        public Xro nonnullXro() {
            return Objects.requireNonNullElse(this.getXro(), XroBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Path.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Path.bindingEquals(this, obj);
        }

        public String toString() {
            return Path.bindingToString(this);
        }
    }
}

