package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.lib.AbstractEntryObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * Class that builds {@link Topology} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Topology createTopology(int fooXyzzy, int barBaz) {
 *         return new TopologyBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Topology, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Topology
 *
 */
@Generated("mdsal-binding-generator")
public class TopologyBuilder {

    private Map<NodeKey, Node> _node;
    private TopologyId _topologyId;
    private TopologyKey key;


    Map<Class<? extends Augmentation<Topology>>, Augmentation<Topology>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public TopologyBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Topology}.
     *
     * @param base Topology from which the builder should be initialized
     */
    public TopologyBuilder(final Topology base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._topologyId = base.getTopologyId();
        this._node = base.getNode();
    }



    /**
     * Return current value associated with the property corresponding to {@link Topology#key()}.
     *
     * @return current value
     */
    public TopologyKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Topology#getNode()}.
     *
     * @return current value
     */
    public Map<NodeKey, Node> getNode() {
        return _node;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Topology#getTopologyId()}.
     *
     * @return current value
     */
    public TopologyId getTopologyId() {
        return _topologyId;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Topology>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Topology#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public TopologyBuilder withKey(final TopologyKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Topology#getNode()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public TopologyBuilder setNode(final Map<NodeKey, Node> values) {
        this._node = values;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Topology#getTopologyId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public TopologyBuilder setTopologyId(final TopologyId value) {
        this._topologyId = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public TopologyBuilder addAugmentation(Augmentation<Topology> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public TopologyBuilder removeAugmentation(Class<? extends Augmentation<Topology>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Topology} instance.
     *
     * @return A new {@link Topology} instance.
     */
    public @NonNull Topology build() {
        return new TopologyImpl(this);
    }

    private static final class TopologyImpl
        extends AbstractEntryObject<Topology, TopologyKey>
        implements Topology {
    
        private final Map<NodeKey, Node> _node;
        private final TopologyId _topologyId;
    
        TopologyImpl(final TopologyBuilder base) {
            super(base.augmentation, extractKey(base));
            final var key = key();
            this._topologyId = key.getTopologyId();
            this._node = CodeHelpers.emptyToNull(base.getNode());
        }
        
        private static @NonNull TopologyKey extractKey(final TopologyBuilder base) {
            final var key = base.key();
            return key != null ? key
                : new TopologyKey(base.getTopologyId());
        }
    
        @Override
        public Map<NodeKey, Node> getNode() {
            return _node;
        }
        
        @Override
        public TopologyId getTopologyId() {
            return _topologyId;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Topology.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Topology.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Topology.bindingToString(this);
        }
    }
}
