package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * This class represents the key of {@link Topology} class.
 *
 * @see Topology
 *
 */
@Generated("mdsal-binding-generator")
public final class TopologyKey
 implements Key<Topology> {
    @java.io.Serial
    private static final long serialVersionUID = 7395505335277930985L;
    private final TopologyId _topologyId;


    /**
     * Constructs an instance.
     *
     * @param _topologyId the entity topologyId
     * @throws NullPointerException if any of the arguments are null
     */
    public TopologyKey(@NonNull TopologyId _topologyId) {
        this._topologyId = CodeHelpers.requireKeyProp(_topologyId, "topologyId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public TopologyKey(TopologyKey source) {
        this._topologyId = source._topologyId;
    }


    /**
     * Return topologyId, guaranteed to be non-null.
     *
     * @return {@code TopologyId} topologyId, guaranteed to be non-null.
     */
    public @NonNull TopologyId getTopologyId() {
        return _topologyId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_topologyId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof TopologyKey other
            && Objects.equals(_topologyId, other._topologyId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(TopologyKey.class);
        CodeHelpers.appendValue(helper, "topologyId", _topologyId);
        return helper.toString();
    }
}

