package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.topology.stats.rpc.rev190321.get.stats.input.topology;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

/**
 * This class represents the key of {@link Node} class.
 *
 * @see Node
 *
 */
@Generated("mdsal-binding-generator")
public final class NodeKey
 implements Key<Node> {
    @java.io.Serial
    private static final long serialVersionUID = -2329891376966659834L;
    private final NodeId _nodeId;


    /**
     * Constructs an instance.
     *
     * @param _nodeId the entity nodeId
     * @throws NullPointerException if any of the arguments are null
     */
    public NodeKey(@NonNull NodeId _nodeId) {
        this._nodeId = CodeHelpers.requireKeyProp(_nodeId, "nodeId");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public NodeKey(NodeKey source) {
        this._nodeId = source._nodeId;
    }


    /**
     * Return nodeId, guaranteed to be non-null.
     *
     * @return {@code NodeId} nodeId, guaranteed to be non-null.
     */
    public @NonNull NodeId getNodeId() {
        return _nodeId;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_nodeId);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof NodeKey other
            && Objects.equals(_nodeId, other._nodeId);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(NodeKey.class);
        CodeHelpers.appendValue(helper, "nodeId", _nodeId);
        return helper.toString();
    }
}

